/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.plugin.rest.admin.controller.RestAdminBaseController;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiServerDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ManageableCredentialsDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAiServerService;
import org.squashtest.tm.plugin.rest.admin.validators.AiServerValidator;
import org.squashtest.tm.plugin.rest.admin.validators.CredentialsValidator;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestAiServerController
extends RestAdminBaseController {
    @Inject
    private RestAiServerService aiServerService;
    @Inject
    protected BasePathAwareLinkBuildingService linkService;
    @Inject
    private ThirdPartyServerCredentialsService serverCredentialsService;
    @Inject
    private AiServerValidator aiServerValidator;
    @Inject
    private AiServerManagerService aiServerManagerService;
    @Inject
    private ThirdPartyServerCredentialsService thirdPartyServerCredentialsService;
    @Inject
    private CredentialsValidator credentialsValidator;
    private AiServerResourceAssembler aiResourceAssembler = new AiServerResourceAssembler();

    @GetMapping(value={"/ai-servers/{id}"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression
    public ResponseEntity<EntityModel<AiServer>> findAiServerById(@PathVariable(value="id") Long aiServerId) {
        AiServer server = this.aiServerService.findAiServerById(aiServerId);
        EntityModel<AiServer> res = this.customResource(server);
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/ai-servers"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression
    public ResponseEntity<PagedModel<EntityModel<AiServer>>> findAllAiServers(Pageable pageable) {
        Page<AiServer> pageAiServer = this.aiServerService.getAllAiServers(pageable);
        PagedModel res = this.pageAssembler.toModel(pageAiServer, (RepresentationModelAssembler)this.aiResourceAssembler);
        return ResponseEntity.ok((Object)res);
    }

    @PatchMapping(value={"/ai-servers/{id}"})
    @ResponseBody
    @DynamicFilterExpression
    public ResponseEntity<EntityModel<AiServer>> patchAiServer(@PathVariable(value="id") Long aiServerId, @RequestBody AiServerDto aiServerDto) throws BindException {
        this.aiServerValidator.aiServerPatchValidator(aiServerId, aiServerDto);
        AiServer aiServer = this.aiServerService.updateAiServer(aiServerId, aiServerDto);
        EntityModel<AiServer> res = this.customResource(aiServer);
        return ResponseEntity.ok(res);
    }

    @DeleteMapping(value={"/ai-servers/{ids}"})
    public ResponseEntity<Void> deleteAiServerByIds(@PathVariable(value="ids") List<Long> aiServerIds) {
        this.aiServerService.deleteAiServers(aiServerIds);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/ai-servers"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EntityModel<AiServer>> addAiServer(@RequestBody AiServerDto aiServerDto) throws BindException {
        this.aiServerValidator.aiServerPostValidator(aiServerDto);
        AiServer aiServer = aiServerDto.dtoToServer();
        AiServer server = this.aiServerService.createNewAiServer(aiServer);
        EntityModel res = this.customResource(server, server.getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @GetMapping(value={"/ai-servers/{id}/credentials"})
    @DynamicFilterExpression
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EntityModel<ManageableCredentials>> getCredential(@PathVariable(value="id") Long aiServerId) {
        ManageableCredentials cred = this.serverCredentialsService.findCredentials(aiServerId.longValue());
        if (Objects.isNull(cred)) {
            return ResponseEntity.noContent().build();
        }
        EntityModel<ManageableCredentials> res = this.customResource(cred);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/ai-servers/{aiServerId}/credentials"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<ManageableCredentials>> setAiServerCredentials(@PathVariable(value="aiServerId") long aiServerId, @RequestBody ManageableCredentialsDto credentialsDto) throws BindException {
        this.credentialsValidator.validatePostCredentialsForAiServer(aiServerId, credentialsDto);
        ManageableCredentials credentials = credentialsDto.convertDto();
        this.thirdPartyServerCredentialsService.storeCredentials(aiServerId, credentials);
        this.aiServerManagerService.forceAuditAfterCredentialsUpdate(aiServerId);
        EntityModel<ManageableCredentials> res = this.customToResourceForCredential(aiServerId, credentials);
        return ResponseEntity.ok(res);
    }

    private EntityModel<ManageableCredentials> customToResourceForCredential(long aiServerId, ManageableCredentials credentials) {
        EntityModel res = EntityModel.of((Object)credentials);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestAiServerController)WebMvcLinkBuilder.methodOn(RestAiServerController.class, (Object[])new Object[0])).getCredential(aiServerId)));
        res.add(builder.withSelfRel());
        return res;
    }

    private class AiServerResourceAssembler
    implements RepresentationModelAssembler<AiServer, EntityModel<AiServer>> {
        private AiServerResourceAssembler() {
        }

        public EntityModel<AiServer> toModel(AiServer entity) {
            EntityModel res = EntityModel.of((Object)entity);
            LinkBuilder builder = RestAiServerController.this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestAiServerController)WebMvcLinkBuilder.methodOn(RestAiServerController.class, (Object[])new Object[0])).findAiServerById(entity.getId())));
            return (EntityModel)res.add(Link.of((String)builder.toString(), (String)"self"));
        }
    }
}

