/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.IterationDto;
import org.squashtest.tm.plugin.rest.jackson.model.IterationTestPlanItemDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.validators.helper.IterationValidationHelper;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.testplanitem.TestPlanItemAssignableUserFinder;

@Component
public class IterationTestPlanItemPostValidator
implements Validator {
    private static final String POST_ITERATION_TEST_PLAN = "post-iteration-test-plan";
    private static final String PATCH_ITERATION_TEST_PLAN = "patch-iteration-test-plan";
    @Inject
    private IterationValidationHelper iterationValidationHelper;
    @Inject
    private TestPlanItemDao testPlanItemDao;
    @Inject
    private UserDao userDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder;

    public boolean supports(Class<?> clazz) {
        return IterationDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        IterationTestPlanItemDto testPlanItemDto = (IterationTestPlanItemDto)target;
        TestCaseDto referencedTcDTo = testPlanItemDto.getReferencedTestCase();
        DatasetDto referencedDatasetDto = testPlanItemDto.getReferencedDataset();
        if (testPlanItemDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing iteration test plan item, please do a patch request to the iteration test plan item id. ");
        }
        if (!referencedTcDTo.getRestType().equals((Object)RestType.TEST_CASE)) {
            errors.rejectValue("_type", "invalid type", "Type test-case expected");
        } else if (referencedTcDTo.getId() == null) {
            errors.rejectValue("id", "generated value", "The test case id must not be null ");
        }
        this.iterationValidationHelper.checkEntityExist(errors, RestType.TEST_CASE, referencedTcDTo.getId());
        if (referencedDatasetDto != null) {
            this.iterationValidationHelper.checkEntityExist(errors, RestType.DATASET, referencedDatasetDto.getId());
            Dataset ds = (Dataset)this.datasetDao.getOne((Object)referencedDatasetDto.getId());
            if (!ds.getTestCase().getId().equals(referencedTcDTo.getId())) {
                errors.rejectValue("id", "invalid value", "This dataset is not attached to this test case");
            }
        }
    }

    public void validatePatchTestPlanItem(IterationTestPlanItemDto itpiDto, Long testPlanId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)itpiDto, PATCH_ITERATION_TEST_PLAN);
        this.iterationValidationHelper.checkEntityExist((Errors)validation, RestType.ITERATION_TEST_PLAN_ITEM, testPlanId);
        TestPlanItem itpi = (TestPlanItem)this.testPlanItemDao.getReferenceById((Object)testPlanId);
        this.validatePatch(itpi, itpiDto, (Errors)validation);
        Long iterationId = itpi.getTestPlan().getParentIteration().getId();
        this.validateAssignedTo(iterationId, itpiDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(itpiDto, errors, PATCH_ITERATION_TEST_PLAN);
    }

    public void validateAssignedTo(Long iterationId, IterationTestPlanItemDto itpiDto, Errors errors) {
        if (itpiDto.getUser() != null) {
            User assignedTo = this.userDao.findUserByLogin(itpiDto.getUser());
            if (assignedTo == null) {
                errors.rejectValue("user", "not found value", "this user does not exist");
            } else {
                List listUser = this.testPlanItemAssignableUserFinder.findAssignableUsersByIterationId(iterationId.longValue());
                if (listUser.size() == 0) {
                    errors.rejectValue("user", "empty value", "no user are assignable for this iteration");
                } else if (!listUser.stream().anyMatch(c -> c.getLogin().equals(assignedTo.getLogin()))) {
                    errors.rejectValue("user", "not found value", "this user is not assignable for this test plan");
                }
            }
        }
    }

    public void validatePostTestPlanItem(IterationTestPlanItemDto iterationTestPlanItemDto, Long iterationId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)iterationTestPlanItemDto, POST_ITERATION_TEST_PLAN);
        this.iterationValidationHelper.checkEntityExist((Errors)validation, RestType.ITERATION, iterationId);
        this.validate(iterationTestPlanItemDto, (Errors)validation);
        this.validateAssignedTo(iterationId, iterationTestPlanItemDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(iterationTestPlanItemDto, errors, POST_ITERATION_TEST_PLAN);
    }

    public void validatePatch(TestPlanItem itpi, IterationTestPlanItemDto itpiDto, Errors errors) {
        TestCase referencedTc = itpi.getReferencedTestCase();
        DatasetDto referencedDatasetDto = itpiDto.getReferencedDataset();
        if (referencedDatasetDto != null && referencedDatasetDto.getId() != null) {
            Dataset ds;
            this.iterationValidationHelper.checkEntityExist(errors, RestType.DATASET, referencedDatasetDto.getId());
            Dataset dataset = ds = referencedDatasetDto.getId() != null ? (Dataset)this.datasetDao.getOne((Object)referencedDatasetDto.getId()) : null;
            if (!ds.getTestCase().getId().equals(referencedTc.getId())) {
                errors.rejectValue("id", "invalid value", "This dataset is not attached to this test case");
            }
        }
    }
}

