/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.plugin.rest.jackson.model.RestActionWordDto;
import org.squashtest.tm.plugin.rest.repository.RestActionWordRepository;
import org.squashtest.tm.plugin.rest.service.RestActionWordService;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.internal.repository.KeywordTestStepDao;
import org.squashtest.tm.service.internal.repository.UsingTestCaseDao;
import org.squashtest.tm.service.project.ProjectFinder;

@Service
@Transactional
public class RestActionWordServiceImpl
implements RestActionWordService {
    @Inject
    private RestActionWordRepository actionWordDao;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private ActionWordLibraryNodeService actionWordLibraryNodeService;
    @Inject
    private KeywordTestStepDao keywordTestStepDao;
    @Autowired(required=false)
    private UsingTestCaseDao usingTestCaseDao;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#actionWordId, 'org.squashtest.tm.domain.bdd.ActionWord', 'READ') or hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public ActionWord getOne(Long actionWordId) {
        return (ActionWord)this.actionWordDao.getReferenceById(actionWordId);
    }

    @Override
    @Transactional(readOnly=true)
    @IsUltimateLicenseAvailable
    public Page<ActionWord> findAllReadableActionWords(Pageable pageable) {
        List projectIds = this.projectFinder.findReadableProjectIdsOnActionWordLibrary();
        return projectIds.isEmpty() ? PaginationUtils.emptyPage(pageable) : this.actionWordDao.findAllInProjects(projectIds, pageable);
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'org.squashtest.tm.domain.bdd.ActionWord', 'WRITE') or hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public ActionWord patchActionWord(long id, RestActionWordDto patch) {
        ActionWord actionWord = (ActionWord)this.actionWordDao.getReferenceById(id);
        actionWord.setDescription(patch.getDescription());
        return actionWord;
    }

    @Override
    @IsUltimateLicenseAvailable
    public ActionWord createActionWord(RestActionWordDto post) {
        ActionWord actionWord = post.convertToDto();
        Project project = (Project)this.entityManager.find(Project.class, (Object)post.getProject().getId());
        ActionWordLibraryNode actionWordLibraryNode = this.actionWordLibraryNodeService.findNodeFromEntity((ActionWordTreeEntity)project.getActionWordLibrary());
        this.actionWordLibraryNodeService.createNewNode(actionWordLibraryNode.getId(), (ActionWordTreeEntity)actionWord);
        return actionWord;
    }

    @Override
    @IsUltimateLicenseAvailable
    public List<Long> deleteActionWordsByIds(List<Long> actionWordIds) {
        List<Long> actionWordLibraryNodeIds = this.actionWordDao.getNodeIdsFromActionWordIds(actionWordIds);
        this.actionWordLibraryNodeService.delete(actionWordLibraryNodeIds);
        return this.findActionWordsAssociatedToKeywordTestSteps(actionWordIds);
    }

    private List<Long> findActionWordsAssociatedToKeywordTestSteps(List<Long> actionWordIds) {
        return actionWordIds.stream().filter(actionWordId -> !this.keywordTestStepDao.findByActionWord(actionWordId).isEmpty()).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true)
    @IsUltimateLicenseAvailable
    public Page<ActionWord> findAllActionWordsByProject(long projectId, Pageable pageable) {
        List readableProjectIds = this.projectFinder.findReadableProjectIdsOnActionWordLibrary();
        if (!readableProjectIds.contains(projectId)) {
            throw new AccessDeniedException("Access denied");
        }
        return this.actionWordDao.findAllInProject(projectId, pageable);
    }

    @Override
    @IsUltimateLicenseAvailable
    public List<TestCase> findAllByActionWord(long actionWordId) {
        return this.getUsingTestCaseDao().findAllByActionWord(actionWordId);
    }

    @Override
    @IsUltimateLicenseAvailable
    public Page<TestCase> findAllByActionWord(long id, Pageable pageable, ColumnFiltering filtering) {
        return this.getUsingTestCaseDao().findPageByActionWord(id, pageable, filtering);
    }

    private UsingTestCaseDao getUsingTestCaseDao() {
        if (Objects.isNull(this.usingTestCaseDao)) {
            throw new AccessDeniedException("A dedicated plugin is required to find test cases using action words");
        }
        return this.usingTestCaseDao;
    }
}

