/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.plugin.rest.service.ExternalDataHandler;
import org.squashtest.tm.plugin.rest.service.TestCaseLibraryFinderService;
import org.squashtest.tm.plugin.rest.service.loader.TestCaseLoader;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;

@Service
public class TestCaseLibraryFinderServiceImpl
implements TestCaseLibraryFinderService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private ExternalDataHandler externalDataHandler;
    @Inject
    private CustomFieldValueFinderService customFieldValueFinderService;

    @Override
    public Page<TestCase> findAllTestCaseByProjectId(long projectId, Pageable pageable, List<String> fields) {
        TestCaseLoader loader = new TestCaseLoader(TestCaseLibraryQuery.FIND_ALL_TEST_CASE_BY_PROJECT_ID.query, Map.of("projectId", projectId), TestCaseLibraryQuery.FIND_ALL_TEST_CASE_BY_PROJECT_ID.countQuery, this.entityManager);
        Page page = loader.loadEntityPage(fields, pageable);
        this.loadExternalAttributes(fields, page.getContent());
        return page;
    }

    private void loadExternalAttributes(List<String> fields, List<TestCase> testCases) {
        if (fields.contains("custom_fields")) {
            Map customFieldValues = this.customFieldValueFinderService.getCufValuesMapByBoundEntity(testCases);
            testCases.forEach(testCase -> Optional.ofNullable((List)customFieldValues.get(testCase.getId())).ifPresent(cufValues -> this.externalDataHandler.addExternalData(testCase, "custom_fields", (List<?>)cufValues)));
        }
    }

    private static enum TestCaseLibraryQuery {
        FIND_ALL_TEST_CASE_BY_PROJECT_ID("SELECT tc FROM TestCase tc WHERE tc.project.id = :projectId", "SELECT COUNT(tc) FROM TestCase tc WHERE tc.project.id = :projectId");

        private final String query;
        private final String countQuery;

        private TestCaseLibraryQuery(String query, String countQuery) {
            this.query = query;
            this.countQuery = countQuery;
        }

        public String getQuery() {
            return this.query;
        }

        public String getCountQuery() {
            return this.countQuery;
        }
    }
}

