/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestStep;

public enum RestType {
    PROJECT("project", Project.class, new HashSet<String>()),
    REQUIREMENT_FOLDER("requirement-folder", RequirementFolder.class, new HashSet<String>(Arrays.asList("project", "requirement-folder"))),
    REQUIREMENT("requirement", Requirement.class, new HashSet<String>(Arrays.asList("project", "requirement-folder", "requirement"))),
    REQUIREMENT_VERSION("requirement-version", RequirementVersion.class, new HashSet<String>(Arrays.asList("project", "requirement-folder", "requirement", "requirement-version"))),
    TEST_CASE_FOLDER("test-case-folder", TestCaseFolder.class, new HashSet<String>(Arrays.asList("project", "test-case-folder"))),
    TEST_CASE("test-case", TestCase.class, new HashSet<String>(Arrays.asList("project", "test-case-folder", "dataset"))),
    TEST_STEP("test-step", TestStep.class, new HashSet<String>()),
    TEST_SUITE("test-suite", TestSuite.class, new HashSet<String>(Arrays.asList("project", "campaign-folder", "campaign", "iteration"))),
    DATASET("dataset", Dataset.class, new HashSet<String>()),
    PARAMETER("parameter", Parameter.class, new HashSet<String>()),
    CAMPAIGN("campaign", Campaign.class, new HashSet<String>(Arrays.asList("project", "campaign-folder"))),
    CAMPAIGN_FOLDER("campaign-folder", CampaignFolder.class, new HashSet<String>(Arrays.asList("project", "campaign-folder"))),
    ITERATION_TEST_PLAN_ITEM("iteration-test-plan-item", TestPlanItem.class, new HashSet<String>(Arrays.asList("iteration-test-plan-item", "test-case", "dataset"))),
    CAMPAIGN_TEST_PLAN_ITEM("campaign-test-plan-item", CampaignTestPlanItem.class, new HashSet<String>(Arrays.asList("campaign-test-plan-item", "test-case", "dataset"))),
    ITERATION("iteration", Iteration.class, new HashSet<String>(Collections.singletonList("campaign"))),
    SCM_REPOSITORY("scm-repository", ScmRepository.class, new HashSet<String>());

    private String typeId;
    private Class typeClass;
    private Set<String> validParent = new HashSet<String>();

    private RestType(String typeId, Class typeClass, Set<String> validParent) {
        this.typeId = typeId;
        this.typeClass = typeClass;
        this.validParent = validParent;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public Class getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class typeClass) {
        this.typeClass = typeClass;
    }

    public static RestType findByTypeName(String enumName) {
        EnumSet<RestType> restTypes = EnumSet.allOf(RestType.class);
        for (RestType restType : restTypes) {
            if (!restType.getTypeId().equals(enumName)) continue;
            return restType;
        }
        return null;
    }

    public Set<String> getValidParent() {
        return this.validParent;
    }

    public void setValidParent(Set<String> validParent) {
        this.validParent = validParent;
    }

    public boolean isValidParentType(RestType type) {
        return this.validParent.contains(type.getTypeId());
    }
}

