/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.webhook;

import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientProvider;
import org.squashtest.tm.plugin.xsquash4gitlab.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementImporter;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronisationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.TechnicalUserHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.webhook.IssueWebhookEventInfo;

@EnableAsync
@Component
public class IssueWebhookAsyncWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueWebhookAsyncWorker.class);
    private final PluginRequirementDao pluginRequirementDao;
    private final Provider<RequirementImporter> requirementImporterProvider;
    private final GitLabClientProvider gitLabClientProvider;
    private final SynchronisationService synchronisationService;
    @PersistenceContext
    private EntityManager entityManager;

    public IssueWebhookAsyncWorker(PluginRequirementDao pluginRequirementDao, Provider<RequirementImporter> requirementImporterProvider, GitLabClientProvider gitLabClientProvider, SynchronisationService synchronisationService) {
        this.pluginRequirementDao = pluginRequirementDao;
        this.requirementImporterProvider = requirementImporterProvider;
        this.gitLabClientProvider = gitLabClientProvider;
        this.synchronisationService = synchronisationService;
    }

    @Transactional
    public void processQueue(List<IssueWebhookEventInfo> events, Runnable done) {
        ArrayList<AsyncProcessResult> asyncProcessResults = new ArrayList<AsyncProcessResult>();
        HashMap<GitLabRemoteSynchronisation, List<IssueWebhookEventInfo>> issuesByCandidateSynchronisation = new HashMap<GitLabRemoteSynchronisation, List<IssueWebhookEventInfo>>();
        try {
            TechnicalUserHelper.performSquashAuthentication();
            this.processRequirementUpdates(events, asyncProcessResults, issuesByCandidateSynchronisation);
            this.processRequirementCreations(asyncProcessResults, issuesByCandidateSynchronisation);
        }
        finally {
            done.run();
            this.logResults(asyncProcessResults);
        }
    }

    private void processRequirementUpdates(List<IssueWebhookEventInfo> events, List<AsyncProcessResult> asyncProcessResults, Map<GitLabRemoteSynchronisation, List<IssueWebhookEventInfo>> issuesByCandidateSynchronisation) {
        List<Long> activeSyncIds = this.pluginRequirementDao.findActiveGitLabRemoteSyncIds();
        for (IssueWebhookEventInfo eventInfo : events) {
            List<PluginRequirementDao.ParentSynchronisation> parentSynchronisations = this.pluginRequirementDao.findParentSynchronisations(eventInfo.issueId);
            List<Long> impactedSynchronisations = parentSynchronisations.stream().filter(ps -> Objects.equals(ps.remoteReqPerimeterStatus, RemoteRequirementPerimeterStatus.IN_CURRENT_PERIMETER.name())).map(ps -> ps.remoteSynchronisationId).collect(Collectors.toList());
            this.traceImpactedSynchronisationCount(impactedSynchronisations, eventInfo);
            for (Long synchronisationId : impactedSynchronisations) {
                AsyncProcessResult result = this.importRemoteIssue(eventInfo, synchronisationId);
                asyncProcessResults.add(result);
            }
            this.findCandidateSynchronisationsForNewRequirement(eventInfo, parentSynchronisations, activeSyncIds).forEach(sync -> {
                issuesByCandidateSynchronisation.putIfAbsent((GitLabRemoteSynchronisation)sync, new ArrayList());
                ((List)issuesByCandidateSynchronisation.get(sync)).add(eventInfo);
            });
        }
    }

    private void traceImpactedSynchronisationCount(List<Long> impactedSynchronisations, IssueWebhookEventInfo eventInfo) {
        if (LOGGER.isTraceEnabled()) {
            if (impactedSynchronisations.isEmpty()) {
                LOGGER.trace(String.format("Received webhook event for untracked issue (%s).", eventInfo.issueUrl));
            } else {
                LOGGER.trace(String.format("Found %d impacted synchronisations for issue (%s).", impactedSynchronisations.size(), eventInfo.issueUrl));
            }
        }
    }

    private void processRequirementCreations(List<AsyncProcessResult> asyncProcessResults, Map<GitLabRemoteSynchronisation, List<IssueWebhookEventInfo>> issuesByCandidateSynchronisation) {
        issuesByCandidateSynchronisation.forEach((sync, eventInfos) -> {
            List<Integer> issueIds = eventInfos.stream().map(eventInfo -> eventInfo.issueId).collect(Collectors.toList());
            List<GitLabIssue> importedIssues = this.synchronisationService.synchroniseIfInPerimeter((GitLabRemoteSynchronisation)sync, issueIds);
            issueIds.forEach(issueId -> {
                boolean wasImported = importedIssues.stream().anyMatch(issue -> issue.getId().equals(String.valueOf(issueId)));
                if (wasImported) {
                    IssueWebhookEventInfo eventInfo = eventInfos.stream().filter(info -> info.issueId == issueId).findAny().orElse(null);
                    asyncProcessResults.add(AsyncProcessResult.creationSuccess(eventInfo, sync.getRemoteSynchronisation().getId()));
                }
            });
        });
    }

    private void logResults(List<AsyncProcessResult> asyncProcessResults) {
        long successCount = asyncProcessResults.stream().filter(result -> result.status.isSuccess()).count();
        if (LOGGER.isInfoEnabled()) {
            String issueUrls = asyncProcessResults.stream().map(res -> res.eventInfo.issueUrl).collect(Collectors.joining(", "));
            LOGGER.info(String.format("Successfully updated %d out of %d requirements (%s).", successCount, asyncProcessResults.size(), issueUrls));
        }
        if (successCount < (long)asyncProcessResults.size()) {
            asyncProcessResults.forEach(AsyncProcessResult::access$1);
        }
    }

    private AsyncProcessResult importRemoteIssue(IssueWebhookEventInfo eventInfo, Long synchronisationId) {
        int remoteIssueId = eventInfo.issueId;
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)synchronisationId);
        GitLabRemoteSynchronisation gitLabRemoteSynchronisation = new GitLabRemoteSynchronisation(remoteSynchronisation);
        RequirementImporter requirementImporter = (RequirementImporter)this.requirementImporterProvider.get();
        GitLabClient client = this.gitLabClientProvider.getGitLabClient(remoteSynchronisation.getServer().getId());
        String issueGlobalId = "gid://gitlab/Issue/" + remoteIssueId;
        Optional<GitLabIssue> issue = client.getIssueClient().findIssueByGlobalIdOnUndeterminedInstanceType(issueGlobalId);
        if (issue.isEmpty()) {
            return AsyncProcessResult.remoteIssueNotFound(eventInfo, synchronisationId);
        }
        if (eventInfo.projectId != issue.get().getProjectId()) {
            return AsyncProcessResult.projectMismatch(eventInfo, synchronisationId, issue.get());
        }
        if (!eventInfo.issueUrl.equals(issue.get().getWebUrl())) {
            return AsyncProcessResult.urlMismatch(eventInfo, synchronisationId, issue.get());
        }
        List<GitLabIssue> singletonList = Collections.singletonList(issue.get());
        requirementImporter.importGitLabIssues(singletonList, gitLabRemoteSynchronisation);
        return AsyncProcessResult.updateSuccess(eventInfo, synchronisationId);
    }

    private Stream<GitLabRemoteSynchronisation> findCandidateSynchronisationsForNewRequirement(IssueWebhookEventInfo eventInfo, List<PluginRequirementDao.ParentSynchronisation> parentSynchronisations, List<Long> activeSyncIds) {
        List allSynchronisationIds = parentSynchronisations.stream().map(ps -> ps.remoteSynchronisationId).collect(Collectors.toList());
        List<Long> unaffectedSynchronisationIds = activeSyncIds.stream().filter(id -> !allSynchronisationIds.contains(id)).collect(Collectors.toList());
        Map<Long, RemoteSynchronisation> synchronisationsById = this.pluginRequirementDao.findRemoteSynchronisations(unaffectedSynchronisationIds);
        return unaffectedSynchronisationIds.stream().map(synchronisationsById::get).filter(Objects::nonNull).map(GitLabRemoteSynchronisation::new).filter(sync -> this.looksLikeItsInSyncPerimeter(eventInfo, (GitLabRemoteSynchronisation)sync));
    }

    private boolean looksLikeItsInSyncPerimeter(IssueWebhookEventInfo eventInfo, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        return eventInfo.projectPathWithNamespace.startsWith(gitLabRemoteSynchronisation.getPerimeter());
    }

    private static final class AsyncProcessResult {
        public final IssueWebhookEventInfo eventInfo;
        public final Long synchronisationId;
        public final AsyncProcessStatus status;
        public final GitLabIssue gitLabIssue;

        public static AsyncProcessResult updateSuccess(IssueWebhookEventInfo eventInfo, Long synchronisationId) {
            return new AsyncProcessResult(eventInfo, synchronisationId, AsyncProcessStatus.UPDATED, null);
        }

        public static AsyncProcessResult creationSuccess(IssueWebhookEventInfo eventInfo, Long synchronisationId) {
            return new AsyncProcessResult(eventInfo, synchronisationId, AsyncProcessStatus.CREATED, null);
        }

        public static AsyncProcessResult remoteIssueNotFound(IssueWebhookEventInfo eventInfo, Long synchronisationId) {
            return new AsyncProcessResult(eventInfo, synchronisationId, AsyncProcessStatus.REMOTE_ISSUE_NOT_FOUND, null);
        }

        public static AsyncProcessResult projectMismatch(IssueWebhookEventInfo eventInfo, Long synchronisationId, GitLabIssue issue) {
            return new AsyncProcessResult(eventInfo, synchronisationId, AsyncProcessStatus.PROJECT_MISMATCH, issue);
        }

        public static AsyncProcessResult urlMismatch(IssueWebhookEventInfo eventInfo, Long synchronisationId, GitLabIssue issue) {
            return new AsyncProcessResult(eventInfo, synchronisationId, AsyncProcessStatus.URL_MISMATCH, issue);
        }

        private AsyncProcessResult(IssueWebhookEventInfo eventInfo, Long synchronisationId, AsyncProcessStatus status, GitLabIssue gitLabIssue) {
            this.eventInfo = eventInfo;
            this.synchronisationId = synchronisationId;
            this.status = status;
            this.gitLabIssue = gitLabIssue;
        }

        private void log() {
            if (!LOGGER.isWarnEnabled()) {
                return;
            }
            switch (this.status) {
                case REMOTE_ISSUE_NOT_FOUND: {
                    LOGGER.warn(String.format("Unable to fetch issue with ID %d, for synchronisation #%d.", this.eventInfo.issueId, this.synchronisationId));
                    break;
                }
                case PROJECT_MISMATCH: {
                    LOGGER.warn(String.format("Project ID mismatch (%d vs. %d). Requirement won't be updated (issue with ID %d, synchronisation #%d).", this.eventInfo.projectId, this.gitLabIssue.getProjectId(), this.eventInfo.issueId, this.synchronisationId));
                    break;
                }
                case URL_MISMATCH: {
                    LOGGER.warn(String.format("Issue URL mismatch : expect '%s' but got '%s'. Requirement won't be updated (issue with ID %d, synchronisation #%d).", this.gitLabIssue.getWebUrl(), this.eventInfo.issueUrl, this.eventInfo.issueId, this.synchronisationId));
                }
            }
        }

        static /* synthetic */ void access$1(AsyncProcessResult asyncProcessResult) {
            asyncProcessResult.log();
        }
    }

    private static enum AsyncProcessStatus {
        CREATED,
        UPDATED,
        REMOTE_ISSUE_NOT_FOUND,
        PROJECT_MISMATCH,
        URL_MISMATCH;


        public boolean isSuccess() {
            return this == CREATED || this == UPDATED;
        }
    }
}

