/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientProvider;
import org.squashtest.tm.plugin.xsquash4gitlab.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationDisplayService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabIssueCollector;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.ExistingReportingNoteFinder;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.GitLabReportingLocaleHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.GitLabReportingService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.scheduling.GitLabReportingScheduler;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatisticsDictionary;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatusService;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

@Service
@Transactional
public class GitLabReportingServiceImpl
implements GitLabReportingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabReportingServiceImpl.class);
    private final RemoteSynchronisationDao remoteSynchronisationDao;
    private final GitLabClientProvider gitLabClientProvider;
    private final GitLabReportingLocaleHelper gitLabReportingLocaleHelper;
    private final ConfigurationService configurationService;
    private final GitLabReportingScheduler reportingScheduler;
    private final RemoteTestingStatusService remoteTestingStatusService;
    private final ConfigurationDisplayService configurationDisplayService;
    private final PluginRequirementDao pluginRequirementDao;
    private final ExistingReportingNoteFinder existingReportingNoteFinder;

    public GitLabReportingServiceImpl(RemoteSynchronisationDao remoteSynchronisationDao, GitLabClientProvider gitLabClientProvider, GitLabReportingLocaleHelper gitLabReportingLocaleHelper, ConfigurationService configurationService, GitLabReportingScheduler reportingScheduler, RemoteTestingStatusService remoteTestingStatusService, ConfigurationDisplayService configurationDisplayService, PluginRequirementDao pluginRequirementDao, ExistingReportingNoteFinder existingReportingNoteFinder) {
        this.remoteSynchronisationDao = remoteSynchronisationDao;
        this.gitLabClientProvider = gitLabClientProvider;
        this.gitLabReportingLocaleHelper = gitLabReportingLocaleHelper;
        this.configurationService = configurationService;
        this.reportingScheduler = reportingScheduler;
        this.remoteTestingStatusService = remoteTestingStatusService;
        this.configurationDisplayService = configurationDisplayService;
        this.pluginRequirementDao = pluginRequirementDao;
        this.existingReportingNoteFinder = existingReportingNoteFinder;
    }

    @Override
    public void performReporting(List<Long> synchronisationIds, GitLabIssueCollector.ReadOnly collectedIssues) {
        if (!this.configurationDisplayService.isCallbackUrlSet()) {
            LOGGER.warn("TM public URL was not set. Reporting will be skipped");
            return;
        }
        List allSynchronisations = this.remoteSynchronisationDao.findAllById(synchronisationIds);
        List<RemoteSynchronisation> synchronisations = allSynchronisations.stream().filter(Objects::nonNull).filter(RemoteSynchronisation::isSynchronisationEnable).toList();
        if (synchronisations.isEmpty()) {
            return;
        }
        Date startTime = new Date();
        LOGGER.debug("Prepare reporting {} synchronisations and {} issues", synchronisationIds, collectedIssues.size());
        RemoteRequirementStatisticsDictionary remoteRequirementStatisticsDictionary = this.remoteTestingStatusService.getRemoteRequirementStatisticsDictionary("squash.tm.plugin.xsquash4gitlab");
        LOGGER.debug("Fetched remote requirement statistics dictionary in {} ms", (Object)(new Date().getTime() - startTime.getTime()));
        HashMap<GitLabClient, Set<NoteProcessInfo>> noteProcessInfosByClient = new HashMap<GitLabClient, Set<NoteProcessInfo>>();
        for (RemoteSynchronisation remoteSynchronisation : synchronisations) {
            boolean isTestReportingDisabled;
            boolean isSynchronisationDisabled = !remoteSynchronisation.isSynchronisationEnable();
            boolean bl = isTestReportingDisabled = !this.configurationService.isTestReportingEnabled(remoteSynchronisation.getProject().getId());
            if (isSynchronisationDisabled || isTestReportingDisabled) continue;
            try {
                GitLabClient client = this.gitLabClientProvider.getGitLabClient(remoteSynchronisation.getServer().getId());
                List<NoteProcessInfo> noteProcessInfos = this.prepareReportingForSynchronisation(remoteSynchronisation, remoteRequirementStatisticsDictionary, collectedIssues, client);
                if (noteProcessInfos.isEmpty()) continue;
                noteProcessInfosByClient.computeIfAbsent(client, k -> new HashSet()).addAll(noteProcessInfos);
            }
            catch (ActionException | DomainException exception) {
                LOGGER.error(MessageFormat.format("Could not prepare note reporting for synchronization #{0}.", remoteSynchronisation.getId()), exception);
            }
        }
        if (!noteProcessInfosByClient.isEmpty()) {
            this.reportingScheduler.collectNoteProcessInfos(noteProcessInfosByClient);
        }
        LOGGER.debug("Finished preparing reporting in {} ms", (Object)(new Date().getTime() - startTime.getTime()));
    }

    private List<NoteProcessInfo> prepareReportingForSynchronisation(RemoteSynchronisation remoteSynchronisation, RemoteRequirementStatisticsDictionary statisticsDictionary, GitLabIssueCollector.ReadOnly collectedIssues, GitLabClient client) {
        List<PluginRequirementDao.SynchronizedRequirementInfo> synchronizedRequirementInfos = this.pluginRequirementDao.findSynchronizedRequirementInfosBySynchronisationId(remoteSynchronisation.getId());
        Long serverId = remoteSynchronisation.getServer().getId();
        return synchronizedRequirementInfos.stream().map(info -> this.prepareReportingForRemoteIssue(statisticsDictionary, serverId, info.remoteReqId(), info.remoteTestingStatusCommentId(), collectedIssues, client)).filter(Objects::nonNull).toList();
    }

    private NoteProcessInfo prepareReportingForRemoteIssue(RemoteRequirementStatisticsDictionary statisticsDictionary, Long serverId, String issueRemoteKey, String trackedCommentId, GitLabIssueCollector.ReadOnly collectedIssues, GitLabClient client) {
        RemoteRequirementStatistics stats = statisticsDictionary.getMergedStatistics(serverId, issueRemoteKey);
        Set reqIds = statisticsDictionary.getRequirementIdsForRemote(serverId, issueRemoteKey);
        String issueGlobalId = "gid://gitlab/Issue/" + issueRemoteKey;
        Optional<GitLabIssue> collectedGitLabIssue = collectedIssues.getIssue(issueGlobalId);
        if (collectedGitLabIssue.isPresent()) {
            GitLabIssue gitLabIssue = collectedGitLabIssue.get();
            Optional<GitLabNote> existingNote = this.existingReportingNoteFinder.findExistingReportingNote(client, gitLabIssue, this.gitLabReportingLocaleHelper.getTmSignature(), trackedCommentId);
            String noteBody = this.gitLabReportingLocaleHelper.buildReportNote(stats, issueRemoteKey, reqIds);
            return this.getNoteProcessInfo(existingNote, noteBody, reqIds, gitLabIssue);
        }
        return null;
    }

    private NoteProcessInfo getNoteProcessInfo(Optional<GitLabNote> existingNote, String noteBody, Set<Long> reqIds, GitLabIssue gitLabIssue) {
        if (existingNote.isPresent()) {
            return this.getNoteProcessInfoIfUpdateIsNeeded(existingNote.get(), noteBody, reqIds, gitLabIssue);
        }
        return NoteProcessInfo.forCreation(reqIds, gitLabIssue.getGlobalId(), noteBody);
    }

    private NoteProcessInfo getNoteProcessInfoIfUpdateIsNeeded(GitLabNote existingNote, String noteBody, Set<Long> reqIds, GitLabIssue gitLabIssue) {
        if (this.noteBodyChanged(existingNote.body(), noteBody)) {
            boolean canEdit = true;
            if (existingNote.userPermissions() != null) {
                canEdit = existingNote.userPermissions().adminNote();
            }
            return NoteProcessInfo.forUpdate(reqIds, gitLabIssue.getGlobalId(), noteBody, existingNote.globalId(), canEdit);
        }
        return null;
    }

    private boolean noteBodyChanged(@NotNull String oldBody, @NotNull String newBody) {
        return !StringUtils.trimAllWhitespace((String)oldBody).equals(StringUtils.trimAllWhitespace((String)newBody));
    }
}

