/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.CreateSynchronisationModel;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabEntityHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabInstanceType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSelectType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.PerimeterType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SprintToCreate;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SyncedRequirementHierarchy;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationReport;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.Xsquash4GitLabConfigurationException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientProvider;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.IssueFetchResult;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.IterationState;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.MilestoneStateEnum;
import org.squashtest.tm.plugin.xsquash4gitlab.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabIssueCollector;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabIssueStatusPerimeterHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabPerimeterService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementImporter;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementMover;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronizedSprintRequirementVersionService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronizedSprintService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.TechnicalUserHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.finder.RemoteRequirementFinder;
import org.squashtest.tm.plugin.xsquash4gitlab.service.finder.RemoteRequirementFinderFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.GitLabReportingService;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.SprintRequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;

@Service(value="squash.tm.plugin.xsquash4gitlab.synchronisationService")
public class SynchronisationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronisationService.class);
    private final Set<String> excludedSprintStatus = Set.of(MilestoneStateEnum.CLOSED.name(), MilestoneStateEnum.$UNKNOWN.name(), IterationState.ALL.name());
    @Value(value="${logging.dir}")
    private String logsFolderPath;
    @Inject
    private Environment environment;
    @PersistenceContext
    private EntityManager entityManager;
    private final Provider<RequirementImporter> requirementImporterProvider;
    private final ConfigurationService configurationService;
    private final RemoteSynchronisationDao remoteSynchronisationDao;
    private final GitLabClientProvider gitLabClientProvider;
    private final GitLabPerimeterService gitLabPerimeterService;
    private final RequirementMover requirementMover;
    private final PluginRequirementDao pluginRequirementDao;
    private final RequirementSyncExtenderDao requirementSyncExtenderDao;
    private final GitLabReportingService gitLabReportingService;
    private final PlatformTransactionManager transactionManager;
    private final SprintDao sprintDao;
    private final SprintGroupDao sprintGroupDao;
    private final SprintReqVersionDao sprintReqVersionDao;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final SprintRequirementSyncExtenderDao sprintRequirementSyncExtenderDao;
    private final RemoteRequirementFinderFactory remoteRequirementFinderFactory;
    private final SynchronizedSprintService synchronizedSprintService;
    private final SynchronizedSprintRequirementVersionService synchronizedSprintRequirementVersionService;

    @Autowired
    public SynchronisationService(Provider<RequirementImporter> requirementImporterProvider, ConfigurationService configurationService, RemoteSynchronisationDao remoteSynchronisationDao, GitLabClientProvider gitLabClientProvider, GitLabPerimeterService gitLabPerimeterService, RequirementMover requirementMover, PluginRequirementDao pluginRequirementDao, RequirementSyncExtenderDao requirementSyncExtenderDao, @Lazy GitLabReportingService gitLabReportingService, PlatformTransactionManager transactionManager, SprintDao sprintDao, SprintGroupDao sprintGroupDao, SprintReqVersionDao sprintReqVersionDao, CampaignLibraryNavigationService campaignLibraryNavigationService, SprintRequirementSyncExtenderDao sprintRequirementSyncExtenderDao, RemoteRequirementFinderFactory remoteRequirementFinderFactory, SynchronizedSprintService synchronizedSprintService, SynchronizedSprintRequirementVersionService synchronizedSprintRequirementVersionService) {
        this.requirementImporterProvider = requirementImporterProvider;
        this.configurationService = configurationService;
        this.remoteSynchronisationDao = remoteSynchronisationDao;
        this.gitLabClientProvider = gitLabClientProvider;
        this.gitLabPerimeterService = gitLabPerimeterService;
        this.requirementMover = requirementMover;
        this.pluginRequirementDao = pluginRequirementDao;
        this.requirementSyncExtenderDao = requirementSyncExtenderDao;
        this.gitLabReportingService = gitLabReportingService;
        this.transactionManager = transactionManager;
        this.sprintDao = sprintDao;
        this.sprintGroupDao = sprintGroupDao;
        this.sprintReqVersionDao = sprintReqVersionDao;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.sprintRequirementSyncExtenderDao = sprintRequirementSyncExtenderDao;
        this.remoteRequirementFinderFactory = remoteRequirementFinderFactory;
        this.synchronizedSprintService = synchronizedSprintService;
        this.synchronizedSprintRequirementVersionService = synchronizedSprintRequirementVersionService;
    }

    @PostConstruct
    public void checkLoggingFilePath() {
        String loggingFilePath = this.environment.getProperty("logging.file.path");
        if (loggingFilePath != null) {
            LOGGER.warn("Xsquash4GitLab plugin : logging.file.path is no longer supported. Current value is the one defined in logging.dir");
        }
    }

    @Transactional(readOnly=true)
    public List<GitLabIssue> simulateNewSynchronisation(long projectId, CreateSynchronisationModel model) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Simulate new sync in project %d", projectId));
        }
        Project project = (Project)this.entityManager.find(Project.class, (Object)projectId);
        try {
            GitLabRemoteSynchronisation sync = this.configurationService.buildGitLabRemoteSynchronisationFromModel(project, model);
            if (model.isCheckMaxItems()) {
                this.gitLabPerimeterService.checkIfMaxNumberOfIssuesInPerimeterExceeded(sync, false);
            }
            return this.getGitLabIssuesInPerimeter((GitLabRemoteSynchronisation)sync).gitLabIssues;
        }
        catch (IOException ioException) {
            throw new Xsquash4GitLabConfigurationException("Error trying to simulate synchronisation", ioException);
        }
    }

    @Transactional(readOnly=true)
    public List<SprintToCreate> simulateNewSprintSynchronisation(long projectId, CreateSynchronisationModel model) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Simulate new sync in project %d", projectId));
        }
        Project project = (Project)this.entityManager.find(Project.class, (Object)projectId);
        try {
            GitLabRemoteSynchronisation sync = this.configurationService.buildGitLabRemoteSynchronisationFromModel(project, model);
            if (model.isCheckMaxItems()) {
                this.gitLabPerimeterService.checkIfMaxNumberOfIssuesInPerimeterExceeded(sync, true);
            }
            IssueFetchResult fetchResult = this.getGitLabIssuesInPerimeter(sync, true);
            List<GitLabIssue> gitLabIssuesInPerimeter = fetchResult.gitLabIssues;
            List<SprintToCreate> sprintsToCreate = this.synchronizedSprintService.getSprintsToCreate(sync).stream().filter(sprintToCreate -> !this.excludedSprintStatus.contains(sprintToCreate.getStatus())).toList();
            for (SprintToCreate sprint : sprintsToCreate) {
                boolean isIterationHierarchy = model.getHierarchy().equals(SyncedRequirementHierarchy.ITERATION.name());
                List<GitLabIssue> associatedIssues = gitLabIssuesInPerimeter.stream().filter(issue -> isIterationHierarchy ? issue.getIteration() != null : issue.getMilestone() != null).filter(issue -> {
                    String gitlabId = isIterationHierarchy ? issue.getIteration().getId() : issue.getMilestone().getId();
                    Long sprintId = SynchronizedSprintService.extractIdFromGitLabId(gitlabId);
                    return sprintId.longValue() == sprint.getId();
                }).toList();
                sprint.setGitLabIssues(associatedIssues);
            }
            return sprintsToCreate;
        }
        catch (IOException ioException) {
            throw new Xsquash4GitLabConfigurationException("Error trying to simulate synchronisation", ioException);
        }
    }

    private IssueFetchResult getGitLabIssuesInPerimeter(GitLabRemoteSynchronisation synchronisation) {
        return this.getGitLabIssuesInPerimeter(synchronisation, false);
    }

    private IssueFetchResult getGitLabIssuesInPerimeter(GitLabRemoteSynchronisation synchronisation, boolean syncForSprints) {
        BugTracker bugTracker = synchronisation.getRemoteSynchronisation().getServer();
        GitLabClient client = this.gitLabClientProvider.getGitLabClient(bugTracker.getId());
        PerimeterType perimeterType = this.gitLabPerimeterService.getPerimeterType(client, synchronisation.getPerimeter());
        if (perimeterType.equals((Object)PerimeterType.PROJECT)) {
            return this.getGitLabIssuesInProject(synchronisation, client, syncForSprints);
        }
        return this.getGitLabIssuesInGroup(synchronisation, client, syncForSprints);
    }

    private IssueFetchResult getGitLabIssuesInProject(GitLabRemoteSynchronisation synchronisation, GitLabClient client, boolean syncForSprints) {
        boolean selectByBoard = syncForSprints ? GitLabRemoteSynchronisation.getSprintSelectType(synchronisation.getRemoteSynchronisation()).equals(GitLabRemoteSelectType.BOARD.name()) : synchronisation.getRemoteSynchronisation().getSelectType().equals(GitLabRemoteSelectType.BOARD.name());
        if (selectByBoard) {
            return client.getProjectClient().getBoardIssues(synchronisation, syncForSprints);
        }
        return client.getProjectClient().getProjectIssues(synchronisation, syncForSprints);
    }

    private IssueFetchResult getGitLabIssuesInGroup(GitLabRemoteSynchronisation synchronisation, GitLabClient client, boolean syncForSprints) {
        boolean selectByBoard = syncForSprints ? GitLabRemoteSynchronisation.getSprintSelectType(synchronisation.getRemoteSynchronisation()).equals(GitLabRemoteSelectType.BOARD.name()) : synchronisation.getRemoteSynchronisation().getSelectType().equals(GitLabRemoteSelectType.BOARD.name());
        if (selectByBoard) {
            return client.getGroupClient().getBoardIssues(synchronisation, syncForSprints);
        }
        return client.getGroupClient().getIssues(synchronisation, syncForSprints);
    }

    public void performSynchronisation() {
        Date startDate = new Date();
        LOGGER.info("Performing synchronisation");
        try {
            TechnicalUserHelper.performSquashAuthentication();
            List<Long> activeSyncIds = this.pluginRequirementDao.findActiveGitLabRemoteSyncIds();
            if (!activeSyncIds.isEmpty()) {
                GitLabIssueCollector issueCollector = new GitLabIssueCollector();
                activeSyncIds.forEach(id -> this.performSynchronisation((long)id, issueCollector));
                this.gitLabReportingService.performReporting(activeSyncIds, issueCollector.readOnly());
            }
        }
        finally {
            SecurityContextHolder.clearContext();
            LOGGER.info("Finished performing synchronisation");
            LOGGER.debug("Performing synchronisation took {} ms", (Object)(new Date().getTime() - startDate.getTime()));
        }
    }

    private void performSynchronisation(long remoteSynchronisationId, GitLabIssueCollector issueCollector) {
        Date startDate = new Date();
        LOGGER.debug("Performing synchronisation with ID {}", (Object)remoteSynchronisationId);
        Date syncStartDate = new Date();
        SynchronisationReport finalReport = new SynchronisationReport();
        this.logSyncStarted(remoteSynchronisationId, syncStartDate);
        try {
            try {
                this.doSynchronisation(finalReport, remoteSynchronisationId, issueCollector);
            }
            catch (Throwable e) {
                String message = String.format("Error during synchronisation %s. Abort and save final status.", remoteSynchronisationId);
                this.createLogFile(e, remoteSynchronisationId);
                LOGGER.error(message, e);
                this.saveFinalSynchronisationStatus(remoteSynchronisationId, finalReport, syncStartDate);
                LOGGER.debug("Finished synchronisation with ID {} in {} ms", (Object)remoteSynchronisationId, (Object)(new Date().getTime() - startDate.getTime()));
            }
        }
        finally {
            this.saveFinalSynchronisationStatus(remoteSynchronisationId, finalReport, syncStartDate);
            LOGGER.debug("Finished synchronisation with ID {} in {} ms", (Object)remoteSynchronisationId, (Object)(new Date().getTime() - startDate.getTime()));
        }
    }

    private void createLogFile(Throwable ex, Long remoteSynchronisationId) {
        File logFolder = new File(this.getPluginLogFolderPath());
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String logFilePath = this.getSyncErrorLogPath(remoteSynchronisationId);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter pw = new PrintWriter(logFilePath);){
                ex.printStackTrace(pw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not generate error log file for synchronisation: (%s)", remoteSynchronisationId), (Throwable)e);
        }
    }

    public String getSyncErrorLogPath(Long syncId) {
        return String.format("%s/%s-sync-%s-error.log", this.getPluginLogFolderPath(), "xsquash4gitlab", syncId.toString());
    }

    private String getPluginLogFolderPath() {
        return this.logsFolderPath + "/xsquash4gitlab";
    }

    private void doSynchronisation(SynchronisationReport synchronisationReport, long remoteSynchronisationId, GitLabIssueCollector issueCollector) {
        this.doInTransaction(() -> {
            HibernateConfig.enableBatch((EntityManager)this.entityManager, (int)50);
            RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
            GitLabRemoteSynchronisation gitLabRemoteSynchronisation = new GitLabRemoteSynchronisation(remoteSynchronisation);
            RequirementImporter requirementImporter = (RequirementImporter)this.requirementImporterProvider.get();
            IssueFetchResult fetchResult = this.getGitLabIssuesInPerimeter(gitLabRemoteSynchronisation);
            List<GitLabIssue> gitLabIssues = fetchResult.gitLabIssues;
            requirementImporter.importGitLabIssues(gitLabIssues, gitLabRemoteSynchronisation);
            issueCollector.collectIssues(gitLabIssues);
            Map<String, Optional<GitLabIssue>> unprocessedGitLabIssues = this.getUnprocessedGitLabIssues(fetchResult, gitLabRemoteSynchronisation);
            this.updateRemoteRequirementPerimeterStatus(gitLabRemoteSynchronisation.getRemoteSynchronisation().getId(), unprocessedGitLabIssues, gitLabIssues);
            this.requirementMover.moveMisplacedRequirements(gitLabRemoteSynchronisation, unprocessedGitLabIssues);
            if (gitLabRemoteSynchronisation.isSprintSynchronisationEnable()) {
                this.doSynchronisationForSprints(synchronisationReport, gitLabRemoteSynchronisation);
            }
            synchronisationReport.setSynchronizedRequirementsCount(gitLabIssues.size());
            synchronisationReport.setUnprocessedRequirementsCount(unprocessedGitLabIssues.size());
        });
        synchronisationReport.setStatus(SynchronisationStatus.SUCCESS);
    }

    public void doSynchronisationForSprints(SynchronisationReport synchronisationReport, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        IssueFetchResult fetchResult = this.getGitLabIssuesInPerimeter(gitLabRemoteSynchronisation, true);
        List<GitLabIssue> gitLabIssuesInPerimeter = fetchResult.gitLabIssues;
        List<SprintToCreate> sprintsToCreate = this.synchronizedSprintService.getSprintsToCreate(gitLabRemoteSynchronisation);
        List<Long> gitLabSprintIds = sprintsToCreate.stream().map(SprintToCreate::getId).toList();
        List sprintList = this.sprintDao.findByRemoteSynchronisationIdAndRemoteSprintIds(Long.valueOf(gitLabRemoteSynchronisation.getRemoteSynchronisation().getId()), gitLabSprintIds);
        Map<Long, Sprint> sprintMap = sprintList.stream().collect(Collectors.toMap(Sprint::getRemoteSprintId, sprint -> sprint));
        Long targetSprintGroupId = this.validateTargetSprintGroup(gitLabRemoteSynchronisation);
        sprintsToCreate.forEach(gitlabSprint -> {
            Sprint squashSprint = (Sprint)sprintMap.get(gitlabSprint.getId());
            gitlabSprint.setStatus(this.synchronizedSprintService.getSquashSprintStatusFromGitLabState(gitLabRemoteSynchronisation, (SprintToCreate)gitlabSprint).name());
            if (!this.excludedSprintStatus.contains(gitlabSprint.getStatus())) {
                squashSprint = this.synchronizedSprintService.createOrUpdateSquashSprint((SprintToCreate)gitlabSprint, squashSprint, gitLabRemoteSynchronisation, targetSprintGroupId);
                this.synchronizeSprintReqVersionsInCampaignWorkspace(synchronisationReport, squashSprint, (SprintToCreate)gitlabSprint, gitLabIssuesInPerimeter, gitLabRemoteSynchronisation, issueFetchResult.instanceType);
            } else if (Objects.nonNull(squashSprint)) {
                squashSprint.setRemoteState(gitlabSprint.getStatus());
                synchronisationReport.addToUnprocessedSprintTicketsCount(squashSprint.getSprintReqVersions().size());
            }
        });
        this.updateSquashKnownSprintStatusForDeletedGitlabSprints(synchronisationReport, gitLabRemoteSynchronisation.getRemoteSynchronisation().getId(), gitLabSprintIds);
    }

    private Long validateTargetSprintGroup(GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        Long remoteSyncId = gitLabRemoteSynchronisation.getId();
        Long targetSprintGroupId = this.sprintGroupDao.findIdByProjectIdAndRemoteSynchronisationId(gitLabRemoteSynchronisation.getProject().getId(), remoteSyncId);
        if (Objects.nonNull(targetSprintGroupId)) {
            return targetSprintGroupId;
        }
        targetSprintGroupId = this.campaignLibraryNavigationService.createSprintGroupAndFoldersHierarchy(gitLabRemoteSynchronisation.getSprintSynchronisationPath());
        this.sprintGroupDao.updateRemoteSyncId(targetSprintGroupId, remoteSyncId);
        return targetSprintGroupId;
    }

    public void synchronizeSprintReqVersionsInCampaignWorkspace(SynchronisationReport synchronisationReport, Sprint squashSprint, SprintToCreate gitlabSprint, List<GitLabIssue> gitLabIssuesInPerimeter, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, GitLabInstanceType instanceType) {
        List<GitLabIssue> issuesInSprint = this.extractGitLabIssuesForSprint(gitlabSprint.getId(), gitLabIssuesInPerimeter, gitLabRemoteSynchronisation);
        RemoteRequirementFinder.Result finderResult = this.remoteRequirementFinderFactory.create().findSprintReqVersionsToUpdate(issuesInSprint, gitLabRemoteSynchronisation.getRemoteSynchronisation().getId(), squashSprint.getId());
        this.synchronizedSprintRequirementVersionService.createOrUpdateSprintReqVersions(squashSprint, issuesInSprint, finderResult, gitLabRemoteSynchronisation);
        this.synchronizedSprintRequirementVersionService.updateSquashKnowSprintReqVersionPerimeterStatus(synchronisationReport, finderResult, gitLabRemoteSynchronisation, instanceType, issuesInSprint, squashSprint.getId());
        synchronisationReport.addToSynchronizedSprintTicketsCount(issuesInSprint.size());
    }

    private List<GitLabIssue> extractGitLabIssuesForSprint(long sprintId, List<GitLabIssue> gitLabIssues, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        return switch (gitLabRemoteSynchronisation.getSyncedRequirementHierarchy()) {
            case SyncedRequirementHierarchy.ITERATION -> this.extractGitLabIssuesForIteration(sprintId, gitLabIssues);
            case SyncedRequirementHierarchy.MILESTONE -> this.extractGitLabIssuesForMilestone(sprintId, gitLabIssues);
            default -> gitLabIssues;
        };
    }

    private List<GitLabIssue> extractGitLabIssuesForIteration(long sprintId, List<GitLabIssue> gitLabIssues) {
        return gitLabIssues.stream().filter(gitLabIssue -> Objects.nonNull(gitLabIssue.getIteration()) && SynchronizedSprintService.extractIdFromGitLabId(gitLabIssue.getIteration().getId()) == sprintId).toList();
    }

    private List<GitLabIssue> extractGitLabIssuesForMilestone(long sprintId, List<GitLabIssue> gitLabIssues) {
        return gitLabIssues.stream().filter(gitLabIssue -> Objects.nonNull(gitLabIssue.getMilestone()) && SynchronizedSprintService.extractIdFromGitLabId(gitLabIssue.getMilestone().getId()) == sprintId).toList();
    }

    private void updateSquashKnownSprintStatusForDeletedGitlabSprints(SynchronisationReport synchronisationReport, Long remoteSyncId, List<Long> gitLabSprintIds) {
        List orphanedSquashSprintIds = this.sprintDao.findSquashSprintIdsHavingDeletedRemoteSprint(remoteSyncId, gitLabSprintIds);
        if (!orphanedSquashSprintIds.isEmpty()) {
            this.sprintDao.updateRemoteStateOfSynchronisedSprintsByIds(orphanedSquashSprintIds, SprintStatus.DELETED.name());
            List orphanedSprintReqVersions = this.sprintReqVersionDao.findIdsBySprintIds(orphanedSquashSprintIds);
            this.sprintRequirementSyncExtenderDao.updatePerimeterStatusForSprintReqVersions(orphanedSprintReqVersions, RemoteRequirementPerimeterStatus.UNKNOWN);
            synchronisationReport.addToUnprocessedSprintTicketsCount(orphanedSprintReqVersions.size());
        }
    }

    public List<GitLabIssue> synchroniseIfInPerimeter(GitLabRemoteSynchronisation synchronisation, List<Integer> issueIdsToCreate) {
        IssueFetchResult fetchResult = this.getGitLabIssuesInPerimeter(synchronisation);
        List<GitLabIssue> matchingIssues = fetchResult.gitLabIssues.stream().filter(issue -> {
            int issueId = Integer.parseInt(issue.getId());
            return issueIdsToCreate.contains(issueId);
        }).toList();
        if (!matchingIssues.isEmpty()) {
            ((RequirementImporter)this.requirementImporterProvider.get()).importGitLabIssues(matchingIssues, synchronisation);
            this.updatePerimeterStatus(synchronisation.getRemoteSynchronisation().getId(), issueIdsToCreate.stream().map(String::valueOf).toList(), RemoteRequirementPerimeterStatus.IN_CURRENT_PERIMETER);
        }
        return matchingIssues;
    }

    private void updateRemoteRequirementPerimeterStatus(Long gitLabRemoteSynchronisationId, Map<String, Optional<GitLabIssue>> unprocessedGitLabIssues, List<GitLabIssue> gitLabIssuesInPerimeter) {
        List<String> inCurrentPerimeterGitLabIssueIds = gitLabIssuesInPerimeter.stream().map(GitLabIssue::getId).toList();
        List<String> outOfPerimeterGitLabIssueIds = GitLabIssueStatusPerimeterHelper.collectOutOfPerimeterGitLabIssueIds(unprocessedGitLabIssues);
        List<String> notFoundGitLabIssueIds = GitLabIssueStatusPerimeterHelper.collectNotFoundGitLabIssueIds(unprocessedGitLabIssues);
        this.updatePerimeterStatus(gitLabRemoteSynchronisationId, inCurrentPerimeterGitLabIssueIds, RemoteRequirementPerimeterStatus.IN_CURRENT_PERIMETER);
        this.updatePerimeterStatus(gitLabRemoteSynchronisationId, outOfPerimeterGitLabIssueIds, RemoteRequirementPerimeterStatus.OUT_OF_CURRENT_PERIMETER);
        this.updatePerimeterStatus(gitLabRemoteSynchronisationId, notFoundGitLabIssueIds, RemoteRequirementPerimeterStatus.NOT_FOUND);
    }

    private void updatePerimeterStatus(Long gitLabRemoteSynchronisationId, List<String> remoteReqKeys, RemoteRequirementPerimeterStatus perimeterStatus) {
        if (!remoteReqKeys.isEmpty()) {
            this.requirementSyncExtenderDao.updatePerimeter(gitLabRemoteSynchronisationId, remoteReqKeys, perimeterStatus);
        }
    }

    private void logSyncStarted(Long remoteSynchronisationId, Date syncDate) {
        this.doInTransaction(() -> {
            RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
            remoteSynchronisation.setLastSyncDate(syncDate);
            remoteSynchronisation.setSynchronisationStatus(SynchronisationStatus.RUNNING);
        });
    }

    private void saveFinalSynchronisationStatus(Long remoteSynchronisationId, SynchronisationReport synchronisationReport, Date syncDate) {
        SynchronisationStatus synchronisationStatus = synchronisationReport.getStatus();
        this.doInTransaction(() -> {
            RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
            remoteSynchronisation.setSynchronisationStatus(synchronisationStatus);
            remoteSynchronisation.setLastSynchronisationStatus(synchronisationStatus);
            if (synchronisationStatus.equals((Object)SynchronisationStatus.SUCCESS)) {
                remoteSynchronisation.setLastSuccessfulSyncDate(syncDate);
                this.saveSynchronizedAndUnprocessedCounts(synchronisationReport, remoteSynchronisation);
            } else {
                this.updatePerimeterAndSprintPerimeterStatuses(remoteSynchronisationId);
            }
        });
    }

    private void saveSynchronizedAndUnprocessedCounts(SynchronisationReport synchronisationReport, RemoteSynchronisation remoteSynchronisation) {
        GitLabRemoteSynchronisation gitLabRemoteSynchronisation = new GitLabRemoteSynchronisation(remoteSynchronisation);
        try {
            gitLabRemoteSynchronisation.setSynchronizedAndUnprocessedCounts(synchronisationReport);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not write the synchronisation counts for remoteSynchronisation (%s)", gitLabRemoteSynchronisation.getRemoteSynchronisation().getId()), (Throwable)e);
        }
    }

    private void updatePerimeterAndSprintPerimeterStatuses(Long remoteSynchronisationId) {
        if (Objects.nonNull(remoteSynchronisationId)) {
            List squashPersistedRemoteReq = this.remoteSynchronisationDao.findAllReqSyncExtenderKeys(remoteSynchronisationId);
            this.updatePerimeterStatus(remoteSynchronisationId, squashPersistedRemoteReq, RemoteRequirementPerimeterStatus.UNKNOWN);
            this.sprintRequirementSyncExtenderDao.updatePerimeterStatusByRemoteSyncId(remoteSynchronisationId, RemoteRequirementPerimeterStatus.UNKNOWN);
        }
    }

    private Map<String, Optional<GitLabIssue>> getUnprocessedGitLabIssues(IssueFetchResult fetchResult, GitLabRemoteSynchronisation synchronisation) {
        List synchronisedKeys = this.remoteSynchronisationDao.findAllReqSyncExtenderKeys(Long.valueOf(synchronisation.getRemoteSynchronisation().getId()));
        List<String> processedKeys = fetchResult.gitLabIssues.stream().map(GitLabEntityHelper::getKey).toList();
        BugTracker bugTracker = synchronisation.getRemoteSynchronisation().getServer();
        GitLabClient client = this.gitLabClientProvider.getGitLabClient(bugTracker.getId());
        return synchronisedKeys.stream().filter(key -> !processedKeys.contains(key)).collect(Collectors.toMap(unprocessedKey -> unprocessedKey, unprocessedKey -> client.fetchGitLabIssue(issueFetchResult.instanceType, (String)unprocessedKey, client)));
    }

    private void doInTransaction(Runnable runnable2) {
        TransactionStatus transaction = null;
        try {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            transactionDefinition.setPropagationBehavior(3);
            transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            runnable2.run();
            this.entityManager.flush();
            this.entityManager.clear();
            this.transactionManager.commit(transaction);
        }
        catch (Exception ex) {
            if (transaction != null && !transaction.isCompleted()) {
                this.transactionManager.rollback(transaction);
            }
            throw ex;
        }
    }
}

