/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.controller.dto;

import java.util.Date;
import java.util.List;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.Mappings;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;

public final class SynchronisationDto {
    private final long id;
    private final String serverName;
    private final long serverId;
    private final String name;
    private final String synchronisationPath;
    private final Date lastSyncDate;
    private final Date lastSuccessfulSyncDate;
    private final String lastStatus;
    private final String status;
    private final boolean isEnabled;
    private final String perimeter;
    private final String remoteSelectType;
    private final String remoteSelectValue;
    private final String syncedRequirementHierarchy;
    private final List<SynchronisationFilterValue> filterValues;
    private final Integer synchronizedRequirementsCount;
    private final Integer unprocessedRequirementsCount;
    private final boolean sprintSynchronisationEnable;
    private List<SynchronisationFilterValue> sprintFilterValues;
    private String sprintSynchronisationPath;
    private String sprintSelectValue;
    private String sprintRemoteSelectType;
    private Integer synchronizedSprintTicketsCount;
    private Integer unprocessedSprintTicketsCount;
    private Mappings mappings;
    private Boolean displayState;

    private SynchronisationDto(RemoteSynchronisation sync, Mappings mappings, Boolean displayState) {
        this.id = sync.getId();
        this.serverName = sync.getServer().getName();
        this.serverId = sync.getServer().getId();
        this.name = sync.getName();
        this.synchronisationPath = GitLabRemoteSynchronisation.getSynchronisationPath(sync);
        this.lastSyncDate = sync.getLastSyncDate();
        this.lastSuccessfulSyncDate = sync.getLastSuccessfulSyncDate();
        this.lastStatus = sync.getLastSynchronisationStatus().name();
        this.status = sync.getSynchronisationStatus().name();
        this.isEnabled = sync.isSynchronisationEnable();
        this.perimeter = GitLabRemoteSynchronisation.getPerimeter(sync);
        this.remoteSelectType = sync.getSelectType();
        this.remoteSelectValue = sync.getSelectValue();
        this.syncedRequirementHierarchy = GitLabRemoteSynchronisation.getSyncedRequirementHierarchy(sync).name();
        this.filterValues = GitLabRemoteSynchronisation.getFilterValuesForDto(sync);
        this.synchronizedRequirementsCount = GitLabRemoteSynchronisation.getSynchronizedRequirementsCount(sync);
        this.unprocessedRequirementsCount = GitLabRemoteSynchronisation.getUnprocessedRequirementsCount(sync);
        if (GitLabRemoteSynchronisation.isSprintSynchronisationEnable(sync)) {
            this.sprintSynchronisationEnable = true;
            this.sprintFilterValues = GitLabRemoteSynchronisation.getSprintFilterValuesForDto(sync);
            this.sprintSynchronisationPath = GitLabRemoteSynchronisation.getSprintSynchronisationPath(sync);
            this.sprintSelectValue = GitLabRemoteSynchronisation.getSprintSelectValue(sync);
            this.sprintRemoteSelectType = GitLabRemoteSynchronisation.getSprintSelectType(sync);
            this.synchronizedSprintTicketsCount = GitLabRemoteSynchronisation.getSynchronizedSprintTicketsCount(sync);
            this.unprocessedSprintTicketsCount = GitLabRemoteSynchronisation.getUnprocessedSprintTicketsCount(sync);
            this.mappings = mappings;
            this.displayState = displayState;
        } else {
            this.sprintSynchronisationEnable = false;
        }
    }

    public static SynchronisationDto fromRemoteSynchronisationAndConfiguration(RemoteSynchronisation sync, Mappings mappings, Boolean displayState) {
        return new SynchronisationDto(sync, mappings, displayState);
    }

    public long getId() {
        return this.id;
    }

    public String getServerName() {
        return this.serverName;
    }

    public long getServerId() {
        return this.serverId;
    }

    public String getName() {
        return this.name;
    }

    public String getSynchronisationPath() {
        return this.synchronisationPath;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public Date getLastSuccessfulSyncDate() {
        return this.lastSuccessfulSyncDate;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean getIsEnabled() {
        return this.isEnabled();
    }

    public String getPerimeter() {
        return this.perimeter;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getRemoteSelectType() {
        return this.remoteSelectType;
    }

    public String getRemoteSelectValue() {
        return this.remoteSelectValue;
    }

    public String getSyncedRequirementHierarchy() {
        return this.syncedRequirementHierarchy;
    }

    public List<SynchronisationFilterValue> getFilterValues() {
        return this.filterValues;
    }

    public List<SynchronisationFilterValue> getSprintFilterValues() {
        return this.sprintFilterValues;
    }

    public boolean isSprintSynchronisationEnable() {
        return this.sprintSynchronisationEnable;
    }

    public String getSprintSynchronisationPath() {
        return this.sprintSynchronisationPath;
    }

    public String getSprintSelectValue() {
        return this.sprintSelectValue;
    }

    public String getSprintRemoteSelectType() {
        return this.sprintRemoteSelectType;
    }

    public Integer getSynchronizedRequirementsCount() {
        return this.synchronizedRequirementsCount;
    }

    public Integer getUnprocessedRequirementsCount() {
        return this.unprocessedRequirementsCount;
    }

    public Integer getSynchronizedSprintTicketsCount() {
        return this.synchronizedSprintTicketsCount;
    }

    public Integer getUnprocessedSprintTicketsCount() {
        return this.unprocessedSprintTicketsCount;
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public Boolean isDisplayState() {
        return this.displayState;
    }
}

