/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.sal.api.features;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import workflowautomjira.com.atlassian.sal.api.features.FeatureKeyScope;
import workflowautomjira.javax.annotation.concurrent.Immutable;

@Immutable
public final class EnabledDarkFeatures {
    public static final EnabledDarkFeatures NONE = new EnabledDarkFeatures((ImmutableMap<FeatureKeyScope, ImmutableSet<String>>)ImmutableMap.of());
    private final ImmutableMap<FeatureKeyScope, ImmutableSet<String>> enabledFeatures;

    public EnabledDarkFeatures(ImmutableMap<FeatureKeyScope, ImmutableSet<String>> enabledFeatures) {
        Preconditions.checkNotNull(enabledFeatures, (Object)"enabledFeatures");
        this.enabledFeatures = ImmutableMap.copyOf(enabledFeatures);
    }

    public ImmutableSet<String> getFeatureKeys() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)this.enabledFeatures.values()));
    }

    public ImmutableSet<String> getFeatureKeys(Predicate<FeatureKeyScope> criteria) {
        Preconditions.checkNotNull(criteria, (Object)"criteria");
        return ImmutableSet.copyOf((Iterable)Iterables.concat(Maps.filterKeys(this.enabledFeatures, criteria).values()));
    }

    public boolean isFeatureEnabled(String featureKey) {
        Preconditions.checkNotNull((Object)featureKey, (Object)"featureKey");
        return Iterables.contains((Iterable)Iterables.concat((Iterable)this.enabledFeatures.values()), (Object)featureKey);
    }

    public String toString() {
        return "EnabledDarkFeatures{enabledFeatures=" + this.enabledFeatures + '}';
    }
}

