/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.client;

import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.plugin.workflow.automjira.domain.CustomFieldInfo;
import org.squashtest.tm.plugin.workflow.automjira.extension.CustomJiraClientFactory;
import org.squashtest.tm.plugin.workflow.automjira.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.workflow.automjira.extension.ExtensionClient;
import org.squashtest.tm.plugin.workflow.automjira.helpers.ConvertValue;
import org.squashtest.tm.plugin.workflow.automjira.helpers.JiraHelper;
import org.squashtest.tm.plugin.workflow.automjira.helpers.Util;
import org.squashtest.tm.plugin.workflow.automjira.json.PageIssueTypeFieldsParser;
import org.squashtest.tm.plugin.workflow.automjira.service.JiraClientService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import workflowautomjira.com.atlassian.httpclient.api.Request;
import workflowautomjira.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import workflowautomjira.com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptionsBuilder;
import workflowautomjira.com.atlassian.jira.rest.client.api.IssueRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.OptionalIterable;
import workflowautomjira.com.atlassian.jira.rest.client.api.ProjectRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.RestClientException;
import workflowautomjira.com.atlassian.jira.rest.client.api.SearchRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicProject;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.CimProject;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.IssueType;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Page;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Project;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.SearchResult;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import workflowautomjira.com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import workflowautomjira.io.atlassian.util.concurrent.Promise;
import workflowautomjira.javax.annotation.Nullable;
import workflowautomjira.javax.ws.rs.core.UriBuilder;

@Component(value="squash.tm.plugin.automjira.AutoWorkflowJiraClient")
@Scope(value="prototype")
public class JiraClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraClient.class);
    private static final String HTTP_AUTHORIZATION = "Authorization";
    private static final String ATLASSIAN_OAUTH2_REST_API_ENDPOINT_STARTER = "https://api.atlassian.com/ex/jira/";
    private static final String ISSUE_URL_SUFFIX = "/browse/";
    private static final Set<String> FIELDS_TO_WATCH;
    private static final int BATCH_SIZE = 50;
    private static final long PAGE_START = 0L;
    private static final int PAGE_MAX_RESULTS = 50;
    private static final String ISSUE_TYPES_PATH_URL = "issue/createmeta/%s/issuetypes/%d";
    private static final PageIssueTypeFieldsParser PAGE_ISSUE_TYPE_FIELDS_PARSER;
    public static final String OPTION = "option";
    public static final String VALUE = "value";
    public static final String SELECT = "select";
    public static final String TEXT = "text";
    public static final String NUMBER = "number";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String CHECKBOX = "checkbox";
    public static final String URL = "url";
    public static final String TEXTAREA = "textarea";
    public static final String LABELS = "labels";
    public static final String MULTI_SELECT = "multiselect";
    public static final String CASCADING_SELECT = "cascadingselect";
    public static final String DUEDATE = "duedate";
    public static final String PARENT = "parent";
    public static final String GH_EPIC_LINK = "gh-epic-link";
    public static final String JSONOBJECT = "JSONObject";
    public static final String BASIC_PROJECT = "project";
    public static final String VERSION = "version";
    public static final String MULTI_VERSION = "multiversion";
    public static final String OPTION_WITH_CHILD = "option-with-child";
    public static final String COMPONENT = "component";
    public static final String FIX_VERSION = "fixversion";
    public static final String PRIORITY = "priority";
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private SynchronizationService synchronizationService;
    @Inject
    private JiraClientService jiraClientService;
    @Inject
    private ConvertValue convertValue;
    @Inject
    private JiraHelper jiraHelper;
    private ExtendedJiraRestClient client;
    private boolean isJiraCloudServer;

    static {
        PAGE_ISSUE_TYPE_FIELDS_PARSER = new PageIssueTypeFieldsParser();
        FIELDS_TO_WATCH = new HashSet<String>();
        FIELDS_TO_WATCH.add("summary");
        FIELDS_TO_WATCH.add("issuetype");
        FIELDS_TO_WATCH.add("created");
        FIELDS_TO_WATCH.add("updated");
        FIELDS_TO_WATCH.add(BASIC_PROJECT);
        FIELDS_TO_WATCH.add("status");
        FIELDS_TO_WATCH.add("assignee");
    }

    public void initialize(BugTracker server, Credentials credentials) {
        URI uri;
        try {
            this.isJiraCloudServer = "jira.cloud".equalsIgnoreCase(server.getKind());
            uri = server.getAuthenticationProtocol() == AuthenticationProtocol.OAUTH_2 && this.isJiraCloudServer ? this.generateJiraCloudApiBaseUrl(server, credentials) : new URI(server.getUrl());
        }
        catch (URISyntaxException ex) {
            String message = this.i18nHelper.getMessage("workflow.automation.jira.validation.invalidurl", new Object[]{server.getUrl()}, "Url " + server.getUrl() + " is not valid.", Util.getLocale());
            LOGGER.error("[AUTOM-JIRA-SYNC] - " + message);
            throw new RuntimeException(message, ex);
        }
        AuthenticationHandler handler = this.createAuthenticationHandler(credentials);
        this.client = new CustomJiraClientFactory().create(uri, handler);
    }

    private URI generateJiraCloudApiBaseUrl(BugTracker bugTracker, Credentials credentials) throws URISyntaxException {
        String cloudId = this.jiraHelper.getCloudIdForOauth2ApiRequest(bugTracker, (OAuth2Credentials)credentials);
        return new URI(ATLASSIAN_OAUTH2_REST_API_ENDPOINT_STARTER + cloudId);
    }

    public void jiraClientAuthentication(BugTracker bugtracker) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - [BUGTRACKER ID : {}] - [BUGTRACKER NAME : {}]", (Object)bugtracker.getId(), (Object)bugtracker.getName());
        }
        Optional maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)bugtracker);
        Credentials credentials = (Credentials)maybeCredentials.get();
        this.initialize(bugtracker, credentials);
    }

    public Iterable<BasicProject> getAllVisibleProjects() {
        return this.client.getProjectClient().getAllProjects().claim();
    }

    public Project getProjectConfiguration(String projectKey) {
        return this.client.getProjectClient().getProject(projectKey).claim();
    }

    public Iterable<CimProject> getFieldsNames(String projectKey, String issueType) {
        GetCreateIssueMetadataOptionsBuilder builder = new GetCreateIssueMetadataOptionsBuilder();
        builder.withProjectKeys(projectKey);
        builder.withIssueTypeNames(issueType);
        return this.client.getIssueClient().getCreateIssueMetadata(builder.build()).claim();
    }

    public BasicIssue createIssue(IssueInput issueInput) {
        IssueRestClient issueRestClient = this.client.getIssueClient();
        BasicIssue remoteIssue = issueRestClient.createIssue(issueInput).claim();
        return remoteIssue;
    }

    public void updateIssueSummary(String issueKey, String summary) {
        IssueInputBuilder builder = new IssueInputBuilder();
        builder.setSummary(summary);
        this.client.getIssueClient().updateIssue(issueKey, builder.build()).claim();
    }

    public void updateIssueByKey(String issueKey, IssueInputBuilder builder) throws RestClientException {
        IssueRestClient issueClient = this.client.getIssueClient();
        issueClient.updateIssue(issueKey, builder.build()).claim();
    }

    public OptionalIterable<IssueType> getRequestTypesByProject(String projectKey) {
        ProjectRestClient project = this.client.getProjectClient();
        Project projectJira = project.getProject(projectKey).claim();
        OptionalIterable<IssueType> listIssueType = projectJira.getIssueTypes();
        return listIssueType;
    }

    public Issue getIssueJira(String issueKey) {
        Issue remoteIssue;
        try {
            remoteIssue = this.client.getIssueClient().getIssue(issueKey).claim();
        }
        catch (RestClientException e) {
            throw new RestClientException(e);
        }
        return remoteIssue;
    }

    public Project getProjectJiraByKey(String projectKey) {
        return this.client.getProjectClient().getProject(projectKey).claim();
    }

    public URL makeViewIssueUrl(BugTracker bugTracker, Issue issueJira) throws MalformedURLException {
        LOGGER.debug("[AUTOM-JIRA-SYNC] - [ISSUE KEY: {}] - BEGIN : finding issue URL", (Object)issueJira.getKey());
        try {
            String strUrl = bugTracker.getUrl().replaceAll("\\/$", "") + ISSUE_URL_SUFFIX + issueJira.getKey();
            return new URL(strUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return new URL(issueJira.getSelf().toString());
        }
    }

    public List<Issue> getListIssueByKey(List<String> listIssueKey) {
        ArrayList<Issue> listRemoteIssue = new ArrayList<Issue>();
        listIssueKey.forEach(issueKey -> {
            Issue remoteIssue = this.client.getIssueClient().getIssue((String)issueKey).claim();
            listRemoteIssue.add(remoteIssue);
        });
        return listRemoteIssue;
    }

    public Promise<SearchResult> getIssueForModificationChecking(String jql, int start, int maxres) {
        SearchRestClient searcher = this.client.getSearchClient();
        return searcher.searchJql(jql, maxres, start, FIELDS_TO_WATCH);
    }

    public Promise<SearchResult> getIssueForModificationCheckingCloud(String jql, String nextPageToken, int maxres) {
        SearchRestClient searcher = this.client.getSearchClient();
        return searcher.searchJqlCloud(jql, maxres, nextPageToken, FIELDS_TO_WATCH);
    }

    public List<CustomFieldInfo> listMandatoryCufsInfoForIssueType(String projectKey, Long issueTypeId) {
        List<CimFieldInfo> cimFieldInfos = this.getCimFieldInfos(projectKey, issueTypeId, 0L, 50);
        List<CustomFieldInfo> listInfoCuf = new ArrayList<CustomFieldInfo>();
        List<CimFieldInfo> requiredFields = this.jiraClientService.getRequiredCimFieldInfos(cimFieldInfos);
        if (!requiredFields.isEmpty()) {
            listInfoCuf = this.jiraClientService.getListCufInfo(requiredFields);
        }
        return listInfoCuf;
    }

    public IssueInput getIssueInput(String projectKey, Long issueTypeId, TestCase testCase, List<CustomFieldInfo> listCufInfo) throws MalformedURLException {
        IssueInputBuilder builder;
        block63: {
            builder = new IssueInputBuilder(projectKey, issueTypeId);
            String summary = this.synchronizationService.buildIssueSummary(testCase);
            String description = this.synchronizationService.buildIssueDescription(testCase);
            builder.setDescription(description);
            builder.setSummary(summary);
            if (listCufInfo == null) break block63;
            for (CustomFieldInfo cuf : listCufInfo) {
                String typeCuf = cuf.getTypeCuf();
                String idCuf = cuf.getIdCuf();
                if (PARENT.equalsIgnoreCase(idCuf)) {
                    typeCuf = PARENT;
                }
                switch (typeCuf) {
                    case "textarea": 
                    case "gh-epic-link": 
                    case "text": {
                        Object value = cuf.getValueCuf();
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "number": {
                        Object value = Float.valueOf(Float.parseFloat(cuf.getValueCuf()));
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "date": {
                        Object value = this.convertValue.convertDateToISOFormat(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "duedate": {
                        Object value = this.convertValue.convertDatetimeToISOFormat(cuf.getValueCuf());
                        builder.setDueDate((DateTime)value);
                    }
                    case "datetime": {
                        Object value = this.convertValue.convertDatetimeToISOFormat(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "option": {
                        Object value = this.convertValue.convertValueToIdAttribute(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, new ComplexIssueInputFieldValue((Map)value));
                        break;
                    }
                    case "project": {
                        Object value = this.convertValue.convertValueToKeyAttribute(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, new ComplexIssueInputFieldValue((Map)value));
                        break;
                    }
                    case "select": {
                        Object value = this.convertValue.convertValueToIdAttribute(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, new ComplexIssueInputFieldValue((Map)value));
                        break;
                    }
                    case "multiselect": 
                    case "checkbox": {
                        Object value = this.convertValue.convertValueToIdList(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "url": {
                        Object value = new URL(cuf.getValueCuf()).toString();
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "labels": {
                        Object value = this.convertValue.extractStringListFromFieldValue(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "cascadingselect": {
                        Object value = this.convertValue.convertValueToAttributeHierarchy(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "version": {
                        Object value = this.convertValue.convertValueToNameAttribute(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, new ComplexIssueInputFieldValue((Map)value));
                        break;
                    }
                    case "multiversion": {
                        Object value = this.convertValue.convertValueToNameList(cuf.getValueCuf());
                        builder.setFieldValue(idCuf, value);
                        break;
                    }
                    case "fixversion": {
                        Object value = this.convertValue.extractStringListFromFieldValue(cuf.getValueCuf());
                        builder.setFixVersionsNames((Iterable)value);
                        break;
                    }
                    case "priority": {
                        Object value = Long.valueOf(cuf.getValueCuf());
                        builder.setPriorityId((Long)value);
                        break;
                    }
                    case "parent": {
                        Object value = this.convertValue.convertValueToKeyAttribute(cuf.getValueCuf());
                        FieldInput parentField = new FieldInput(idCuf, (Object)new ComplexIssueInputFieldValue((Map)value));
                        builder.setFieldInput(parentField);
                    }
                }
            }
        }
        return builder.build();
    }

    public List<Issue> listIssuesUpdateOnJira(RemoteSynchronisation remoteSynchronisation) {
        return this.isJiraCloudServer ? this.fetchIssuesCloud(remoteSynchronisation) : this.fetchIssues(remoteSynchronisation);
    }

    private List<Issue> fetchIssuesCloud(RemoteSynchronisation remoteSynchronisation) {
        String filter = remoteSynchronisation.getSelectValue();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        String nextPageToken = null;
        do {
            try {
                SearchResult res = this.getIssueForModificationCheckingCloud(filter, nextPageToken, 50).claim();
                issues.addAll(Util.toList(res.getIssues()));
                nextPageToken = res.getNextPageToken();
            }
            catch (RestClientException ex) {
                this.logSearchError(remoteSynchronisation, filter, ex);
                break;
            }
        } while (nextPageToken != null);
        return issues;
    }

    private List<Issue> fetchIssues(RemoteSynchronisation remoteSynchronisation) {
        int increment;
        String filter = remoteSynchronisation.getSelectValue();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        int processed = 0;
        int total = 0;
        do {
            try {
                SearchResult res = this.getIssueForModificationChecking(filter, processed, 50).claim();
                total = res.getTotal();
                increment = Math.min(50, total - processed);
                issues.addAll(Util.toList(res.getIssues()));
            }
            catch (RestClientException ex) {
                this.logSearchError(remoteSynchronisation, filter, ex);
                break;
            }
        } while ((processed += increment) < total);
        return issues;
    }

    private void logSearchError(RemoteSynchronisation remoteSynchronisation, String filter, RestClientException ex) {
        LOGGER.error("[AUTOM-JIRA-SYNC] - Project id: {} name: {} - Synchronisation id: {} name: {} - Server id: {} name: {}  - An error occurred while searching jql with this filter: {}", new Object[]{remoteSynchronisation.getProject().getId(), remoteSynchronisation.getProject().getName(), remoteSynchronisation.getId(), remoteSynchronisation.getName(), remoteSynchronisation.getServer().getId(), filter, ex});
    }

    private List<CimFieldInfo> getCimFieldInfos(String projectKey, Long issueTypeId, long start, int maxResults) {
        Page<CimFieldInfo> pageCimFieldInfos = this.doRetrieveCimFieldInfos(projectKey, issueTypeId, start, maxResults);
        ArrayList cimFieldInfos = Lists.newArrayList(pageCimFieldInfos.getValues());
        if (!pageCimFieldInfos.isLast()) {
            cimFieldInfos.addAll(this.getCimFieldInfos(projectKey, issueTypeId, pageCimFieldInfos.getStartAt() + (long)pageCimFieldInfos.getMaxResults(), pageCimFieldInfos.getMaxResults()));
        }
        return cimFieldInfos;
    }

    private Page<CimFieldInfo> doRetrieveCimFieldInfos(String projectKey, Long issueTypeId, long start, int maxResults) {
        ExtensionClient extension = this.client.getExtensionClient();
        String issueTypesPath = String.format(ISSUE_TYPES_PATH_URL, projectKey, issueTypeId);
        UriBuilder uriBuilder = UriBuilder.fromUri(extension.getBaseURI()).path(issueTypesPath);
        this.addPagingParameters(uriBuilder, start, maxResults);
        return extension.getAndParse(uriBuilder.build(new Object[0]), PAGE_ISSUE_TYPE_FIELDS_PARSER).claim();
    }

    private void addPagingParameters(UriBuilder uriBuilder, @Nullable Long startAt, @Nullable Integer maxResults) {
        if (startAt != null) {
            uriBuilder.queryParam("startAt", startAt);
        }
        if (maxResults != null) {
            uriBuilder.queryParam("maxResults", maxResults);
        }
    }

    @Override
    public void close() {
        String message = this.i18nHelper.internationalize("workflow.automation.jira.close.client", Util.getLocale());
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private AuthenticationHandler createAuthenticationHandler(Credentials credentials) {
        switch (credentials.getImplementedProtocol()) {
            case BASIC_AUTH: {
                BasicAuthenticationCredentials basicCredentials = (BasicAuthenticationCredentials)credentials;
                return new BasicHttpAuthenticationHandler(basicCredentials.getUsername(), new String(basicCredentials.getPassword()));
            }
            case OAUTH_2: {
                OAuth2Credentials oauth2Creds = (OAuth2Credentials)credentials;
                return new OAuth2Handler(oauth2Creds);
            }
        }
        throw new UnsupportedAuthenticationModeException(credentials.getImplementedProtocol().toString());
    }

    private static final class OAuth2Handler
    implements AuthenticationHandler {
        private final OAuth2Credentials credentials;

        public OAuth2Handler(OAuth2Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public void configure(Request.Builder builder) {
            String tokenType = StringUtils.capitalize((String)this.credentials.getTokenType());
            builder.setHeader(JiraClient.HTTP_AUTHORIZATION, String.format("%s %s", tokenType, this.credentials.getAccessToken()));
        }
    }
}

