/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.premium.actionword.service.grid;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class UsingTestCaseGrid
extends AbstractGrid {
    private static final String AUTOMATION_STATUS = "AUTOMATION_STATUS";
    private static final String REMOTE_STATUS = "REMOTE_STATUS";
    private final long actionWordId;

    public UsingTestCaseGrid(long actionWordId) {
        this.actionWordId = actionWordId;
    }

    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(Tables.TEST_CASE.TCLN_ID.as("ID")), new GridColumn((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME), new GridColumn(Tables.PROJECT.NAME.as("PROJECT_NAME")), new GridColumn((Field)Tables.TEST_CASE.REFERENCE), new GridColumn(Tables.TEST_CASE.TC_STATUS.as("STATUS")), new GridColumn((Field)Tables.TEST_CASE.IMPORTANCE), new GridColumn(this.getAutomationStatus().as(AUTOMATION_STATUS)), new GridColumn(Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.REMOTE_STATUS.as(REMOTE_STATUS)), new GridColumn((Field)Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW), new GridColumn((Field)Tables.TEST_CASE.AUTOMATABLE));
    }

    protected Table<?> getTable() {
        return Tables.TEST_CASE.innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).innerJoin((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.AUTOMATION_REQUEST_ID)).asTable();
    }

    private Field<?> getAutomationStatus() {
        return DSL.ifnull((Field)Tables.REMOTE_AUTOMATION_REQUEST_EXTENDER.REMOTE_STATUS, (Field)Tables.AUTOMATION_REQUEST.REQUEST_STATUS);
    }

    protected Field<?> getIdentifier() {
        return DSL.field((String)"ID");
    }

    protected Field<?> getProjectIdentifier() {
        return null;
    }

    protected SortField<?> getDefaultOrder() {
        return DSL.upper((String)"PROJECT_NAME").asc();
    }

    protected Condition craftInvariantFilter() {
        return Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID.eq((Object)this.actionWordId);
    }
}

