/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.Header;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HeaderElement;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HeaderIterator;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpResponse;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods.HttpRequestBase;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

public class HttpOptions
extends HttpRequestBase {
    public static final String METHOD_NAME = "OPTIONS";

    public HttpOptions() {
    }

    public HttpOptions(URI uri) {
        this.setURI(uri);
    }

    public HttpOptions(String uri) {
        this.setURI(URI.create(uri));
    }

    @Override
    public String getMethod() {
        return METHOD_NAME;
    }

    public Set<String> getAllowedMethods(HttpResponse response) {
        Args.notNull(response, "HTTP response");
        HeaderIterator it = response.headerIterator("Allow");
        HashSet<String> methods = new HashSet<String>();
        while (it.hasNext()) {
            HeaderElement[] elements;
            Header header = it.nextHeader();
            for (HeaderElement element : elements = header.getElements()) {
                methods.add(element.getName());
            }
        }
        return methods;
    }
}

