/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.testcases.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.api.repository.SqlQueryRunner;

public class TestCasesTreeQueryFinder {
    private static final String TAGS = "tags";
    private static final String MILESTONES = "milestones";
    private static final String ENTITY_TYPE = "entityType";
    private static final String ENTITY_IDS = "entityIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String NODE_IDS = "nodeIds";
    private static final String TEST_CASE_IDS = "testcaseIds";
    private static final String TEST_CASE_ID = "testcaseId";
    private static final String TEST_CASE_SORT_ORDER = "testCaseSortOrder";
    private String idsByProjectQuery;
    private String idsBySelectionQuery;
    private String idsByMilestoneQuery;
    private String idsByTagQuery;
    private String testCasesQuery;
    private String linkedReqQuery;
    private String testCaseStepsQuery;
    private String bddActionFragmentsQuery;
    private String cufQuery;
    private String rtfCufQuery;
    private String tagCufQuery;
    private String numCufQuery;
    private String nodesByTestCaseIdsQuery;
    private String nodesByMilestonesQuery;
    private String nodesByTagsQuery;
    private String nodesByProjectIdsQuery;
    private String testStepsByCallSteps;
    private String linkedReqByTestStepQuery;
    private String parametersQuery;
    private String dataSetQuery;
    private String dataSetParamValueQuery;
    private String milestoneConfigurationQuery;
    SqlQueryRunner runner;

    void setIdsByProjectQuery(String idsByProjectQuery) {
        this.idsByProjectQuery = idsByProjectQuery;
    }

    void setIdsBySelectionQuery(String idsBySelectionQuery) {
        this.idsBySelectionQuery = idsBySelectionQuery;
    }

    void setIdsByMilestoneQuery(String idsByMilestoneQuery) {
        this.idsByMilestoneQuery = idsByMilestoneQuery;
    }

    void setIdsByTagQuery(String idsByTagQuery) {
        this.idsByTagQuery = idsByTagQuery;
    }

    void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    void setTestCasesQuery(String testCasesQuery) {
        this.testCasesQuery = testCasesQuery;
    }

    void setTestCaseStepsQuery(String testCaseStepsQuery) {
        this.testCaseStepsQuery = testCaseStepsQuery;
    }

    public void setBddActionFragmentsQuery(String bddActionFragmentsQuery) {
        this.bddActionFragmentsQuery = bddActionFragmentsQuery;
    }

    void setLinkedReqQuery(String linkedReqQuery) {
        this.linkedReqQuery = linkedReqQuery;
    }

    void setCufQuery(String cufQuery) {
        this.cufQuery = cufQuery;
    }

    void setRtfCufQuery(String rtfCufQuery) {
        this.rtfCufQuery = rtfCufQuery;
    }

    void setTagCufQuery(String tagCufQuery) {
        this.tagCufQuery = tagCufQuery;
    }

    void setNumCufQuery(String numCufQuery) {
        this.numCufQuery = numCufQuery;
    }

    void setNodesByTestCaseIdsQuery(String nodesByTestCaseIdsQuery) {
        this.nodesByTestCaseIdsQuery = nodesByTestCaseIdsQuery;
    }

    void setNodesByMilestonesQuery(String nodesByMilestonesQuery) {
        this.nodesByMilestonesQuery = nodesByMilestonesQuery;
    }

    void setNodesByTagsQuery(String nodesByTagsQuery) {
        this.nodesByTagsQuery = nodesByTagsQuery;
    }

    void setNodesByProjectIdsQuery(String nodesByProjectIdsQuery) {
        this.nodesByProjectIdsQuery = nodesByProjectIdsQuery;
    }

    void setTestStepsByCallSteps(String testStepsByCallSteps) {
        this.testStepsByCallSteps = testStepsByCallSteps;
    }

    void setLinkedReqByTestStepQuery(String linkedReqByTestStepQuery) {
        this.linkedReqByTestStepQuery = linkedReqByTestStepQuery;
    }

    void setParametersQuery(String parametersQuery) {
        this.parametersQuery = parametersQuery;
    }

    void setMilestoneConfigurationQuery(String milestoneConfigurationQuery) {
        this.milestoneConfigurationQuery = milestoneConfigurationQuery;
    }

    void setDataSetQuery(String dataSetQuery) {
        this.dataSetQuery = dataSetQuery;
    }

    void setDataSetParamValueQuery(String dataSetParamValueQuery) {
        this.dataSetParamValueQuery = dataSetParamValueQuery;
    }

    Collection<Long> findIdsByProject(List<Long> projectIds) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return Collections.emptyList();
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>(1);
        params.put(PROJECT_IDS, projectIds);
        List foundStrIds = this.runner.executeSelect(this.idsByProjectQuery, params);
        return this.toIdList(foundStrIds);
    }

    Collection<Long> findIdsBySelection(Collection<String> ids, List<Long> projectIds) {
        LinkedList<Long> versionIds = new LinkedList();
        if (ids != null && !ids.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
            params.put(NODE_IDS, this.toIdList(ids));
            params.put(PROJECT_IDS, projectIds);
            List foundStrIds = this.runner.executeSelect(this.idsBySelectionQuery, params);
            versionIds.addAll(this.toIdList(foundStrIds));
        } else {
            versionIds = new ArrayList();
        }
        return versionIds;
    }

    Collection<Long> findIdsByMilestone(Collection<String> milestoneIds, List<Long> projectIds) {
        if (!milestoneIds.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
            params.put(MILESTONES, this.toIdList(milestoneIds));
            params.put(PROJECT_IDS, projectIds);
            List foundIds = this.runner.executeSelect(this.idsByMilestoneQuery, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    Collection<Long> findIdsByTags(Collection<String> tags, List<Long> projectIds) {
        if (!tags.isEmpty()) {
            HashMap<String, Collection<Object>> params = new HashMap<String, Collection<Object>>();
            params.put(TAGS, tags);
            params.put(PROJECT_IDS, projectIds);
            List foundIds = this.runner.executeSelect(this.idsByTagQuery, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    Collection<Object[]> getTestCasesData(Collection<Long> testCaseIds, String testCaseSortOrder) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TEST_CASE_IDS, testCaseIds);
        params.put(TEST_CASE_SORT_ORDER, testCaseSortOrder);
        return this.execute(this.testCasesQuery, params);
    }

    Collection<Object[]> getMilestoneConfiguration() {
        return this.runner.executeSelect(this.milestoneConfigurationQuery);
    }

    Collection<Object[]> getLinkedReqStepsData(Collection<Long> testStepsIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("testStepIds", testStepsIds);
        return this.execute(this.linkedReqByTestStepQuery, params);
    }

    Collection<Object[]> getLinkedReqData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.linkedReqQuery, params);
    }

    Collection<Object[]> getTestCaseStepsData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.testCaseStepsQuery, params);
    }

    Collection<Object[]> getBddActionFragmentsData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.bddActionFragmentsQuery, params);
    }

    Collection<Object[]> getCufData(String entityType, Collection<Long> entityIds) {
        return this.executeCufQuery(entityType, entityIds, this.cufQuery);
    }

    Collection<Object[]> getNumCufData(String entityType, Collection<Long> entityIds) {
        return this.executeCufQuery(entityType, entityIds, this.numCufQuery);
    }

    Collection<Object[]> getRtfCufData(String entityType, Collection<Long> entityIds) {
        return this.executeCufQuery(entityType, entityIds, this.rtfCufQuery);
    }

    Collection<Object[]> getTagCufData(String entityType, Collection<Long> entityIds) {
        return this.executeCufQuery(entityType, entityIds, this.tagCufQuery);
    }

    Collection<Object[]> getNodesByTestCasesIds(Collection<String> testCaseIds, List<Long> projectIds, String testCaseSortOrder) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put(NODE_IDS, this.toIdList(testCaseIds));
        params.put(PROJECT_IDS, projectIds);
        params.put(TEST_CASE_SORT_ORDER, testCaseSortOrder);
        return this.execute(this.nodesByTestCaseIdsQuery, params);
    }

    Collection<Object[]> getNodesByMilestones(Collection<String> milestones, List<Long> projectIds, String testCaseSortOrder) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put(MILESTONES, this.toIdList(milestones));
        params.put(PROJECT_IDS, projectIds);
        params.put(TEST_CASE_SORT_ORDER, testCaseSortOrder);
        return this.execute(this.nodesByMilestonesQuery, params);
    }

    Collection<Object[]> getNodesTags(Collection<String> tags, List<Long> projectIds, String testCaseSortOrder) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put(TAGS, tags);
        params.put(PROJECT_IDS, projectIds);
        params.put(TEST_CASE_SORT_ORDER, testCaseSortOrder);
        return this.execute(this.nodesByTagsQuery, params);
    }

    Collection<Object[]> getNodesByProjectIds(List<Long> projectIds, String testCaseSortOrder) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put(PROJECT_IDS, projectIds);
        params.put(TEST_CASE_SORT_ORDER, testCaseSortOrder);
        return this.execute(this.nodesByProjectIdsQuery, params);
    }

    Collection<Object[]> getTestCaseStepsData(Long testCaseId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put(TEST_CASE_ID, testCaseId);
        return this.execute(this.testStepsByCallSteps, params);
    }

    Collection<Object[]> getParametersData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.parametersQuery, params);
    }

    Collection<Object[]> getDataSetData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.dataSetQuery, params);
    }

    Collection<Object[]> getDataSetParamValueData(Collection<Long> testCaseIds) {
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put(TEST_CASE_IDS, testCaseIds);
        return this.execute(this.dataSetParamValueQuery, params);
    }

    Collection<Long> toIdList(Collection<?> ids) {
        return CollectionUtils.collect(ids, (Transformer)new IdTransformer());
    }

    private Collection<Object[]> executeCufQuery(String entityType, Collection<Long> entityIds, String query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ENTITY_TYPE, entityType);
        params.put(ENTITY_IDS, entityIds);
        return this.execute(query, params);
    }

    private Collection<Object[]> execute(String query, Map<String, ?> params) {
        return this.runner.executeSelect(query, params);
    }

    private static class IdTransformer
    implements Transformer {
        private IdTransformer() {
        }

        public Object transform(Object arg0) {
            String className;
            if (arg0 == null) {
                throw new IllegalArgumentException("ID cannot be null");
            }
            return switch (className = arg0.getClass().getName()) {
                case "java.lang.String" -> Long.valueOf((String)arg0);
                case "java.math.BigInteger" -> ((BigInteger)arg0).longValue();
                case "java.lang.Integer" -> (long)((Integer)arg0).intValue();
                case "java.lang.Long" -> arg0;
                default -> throw new IllegalArgumentException("IdTransformer cannot convert items of class %s".formatted(className));
            };
        }
    }
}

