/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.testcases.query;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.plugin.report.books.testcases.beans.ActionWordFragmentValueDto;
import org.squashtest.tm.plugin.report.books.testcases.beans.ActionWordParameterValueDto;
import org.squashtest.tm.plugin.report.books.testcases.beans.ActionWordTextValueDto;
import org.squashtest.tm.plugin.report.books.testcases.beans.Cuf;
import org.squashtest.tm.plugin.report.books.testcases.beans.Dataset;
import org.squashtest.tm.plugin.report.books.testcases.beans.DatasetParamValue;
import org.squashtest.tm.plugin.report.books.testcases.beans.I18nHelper;
import org.squashtest.tm.plugin.report.books.testcases.beans.LinkedRequirements;
import org.squashtest.tm.plugin.report.books.testcases.beans.Node;
import org.squashtest.tm.plugin.report.books.testcases.beans.Parameter;
import org.squashtest.tm.plugin.report.books.testcases.beans.PrintableCuf;
import org.squashtest.tm.plugin.report.books.testcases.beans.TestCase;
import org.squashtest.tm.plugin.report.books.testcases.beans.TestCaseSteps;
import org.squashtest.tm.plugin.report.books.testcases.query.TestCaseHierarchyHelper;

public class TestCasesTreeFormatter {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestCasesTreeFormatter.class);
    private static final String END_SEPARATOR_PLACEHOLDER = "=Sep=";
    private static final String SORTING_CHAIN_SEPARATOR = " ";
    private static final String CHAIN_SEPARATOR = " > ";
    private static final String SEPARATOR_PLACEHOLDER = "=Sep=,";
    private static final String MILESTONE_SEPARATOR = ", ";
    private static final String TAG_EMPTY = "";
    private static final String TAG_SEPARATOR = " | ";
    private static final String DATE_REGEX = "\\d{4}\\-(0?[1-9]|1[012])\\-(0?[1-9]|[12][0-9]|3[01])*";
    private static final int MAX_IMAGE_SIZE = 700;
    private TestCaseHierarchyHelper hierarchyHelper;
    private String projectName;
    private List<Long> tcIdsAlreadyAdd;
    private AttachmentImageHelper attachmentImageHelper;

    public void setAttachmentImageHelper(AttachmentImageHelper attachmentImageHelper) {
        this.attachmentImageHelper = attachmentImageHelper;
    }

    public Collection<TestCaseSteps> toTestCaseSteps(Collection<Object[]> testCaseStepsData, Collection<ActionWordFragmentValueDto> bddActionFragments, boolean printAttachments, boolean printLinkedReq, boolean printCufs) {
        ArrayList<TestCaseSteps> result = new ArrayList<TestCaseSteps>();
        for (Object[] array : testCaseStepsData) {
            TestCaseSteps testCaseStepsBean = new TestCaseSteps();
            testCaseStepsBean.setId(this.evaluateExpressionToLong(array[0]));
            String action = this.evaluateExpressionToString(array[1]);
            if ("C".equals(this.evaluateExpressionToString(array[3]))) {
                testCaseStepsBean.setHasNoResult(true);
                ArrayList<String> params = new ArrayList<String>();
                params.add(action);
                action = I18nHelper.translate("report.books.testcases.steps.call", params.toArray());
                testCaseStepsBean.setDelegateParameterValues(this.evaluateExpressionToBoolean(array[14]));
                if (!this.evaluateExpressionToString(array[5]).isBlank()) {
                    params.add(this.evaluateExpressionToString(array[5]));
                    action = I18nHelper.translate("report.books.testcases.steps.call.dataset", params.toArray());
                } else if (testCaseStepsBean.isDelegateParameterValues()) {
                    params.add(this.evaluateExpressionToString(I18nHelper.translate("report.books.callstepdataset.Delegate")));
                    action = I18nHelper.translate("report.books.testcases.steps.call.dataset", params.toArray());
                }
            } else if ("K".equals(this.evaluateExpressionToString(array[3]))) {
                testCaseStepsBean.setKeyword(this.evaluateExpressionToString(array[9]));
                testCaseStepsBean.setBddAction(this.buildBddActionForStep(testCaseStepsBean.getId(), bddActionFragments));
                testCaseStepsBean.setDatatable(this.evaluateExpressionToString(array[10]));
                testCaseStepsBean.setDocstring(this.evaluateExpressionToString(array[11]));
                testCaseStepsBean.setComment(this.evaluateExpressionToString(array[12]));
                testCaseStepsBean.setBddScriptLocale(I18nHelper.toLocale(this.evaluateExpressionToString(array[13])));
            }
            testCaseStepsBean.setAction(action);
            testCaseStepsBean.setExpectedResult(this.evaluateExpressionToString(array[2]));
            testCaseStepsBean.setType(this.evaluateExpressionToString(array[3]));
            testCaseStepsBean.setOrder(this.evaluateExpressionToLong(array[4]));
            testCaseStepsBean.setDataset(this.evaluateExpressionToString(array[5]));
            testCaseStepsBean.setAttach(this.evaluateExpressionToLong(array[6]));
            testCaseStepsBean.setRequirement(this.evaluateExpressionToLong(array[7]));
            testCaseStepsBean.setTestCaseId(this.evaluateExpressionToLong(array[8]));
            testCaseStepsBean.setPrintAttachments(printAttachments);
            testCaseStepsBean.setPrintStepLinkedReq(printLinkedReq);
            testCaseStepsBean.setPrintCufs(printCufs);
            result.add(testCaseStepsBean);
        }
        return result;
    }

    private String buildBddActionForStep(Long stepId, Collection<ActionWordFragmentValueDto> bddActionFragments) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ActionWordFragmentValueDto fragment : bddActionFragments) {
            if (!stepId.equals(fragment.getKeywordStepId())) continue;
            stringBuilder.append(fragment.getUnstyledAction());
        }
        return stringBuilder.toString();
    }

    public Collection<PrintableCuf> toPrintableCufCollection(Collection<Cuf> cufsCollection, Collection<Cuf> numCufsCollection, Collection<Cuf> tagCufsCollection, Collection<Cuf> rtfCufsCollection, List<String> html) {
        ArrayList<PrintableCuf> result = new ArrayList<PrintableCuf>();
        for (Cuf cuf : cufsCollection) {
            this.toPrintableCuf(cuf, result, html);
        }
        for (Cuf numCuf : numCufsCollection) {
            this.toPrintableCuf(numCuf, result, html);
        }
        for (Cuf tagCuf : tagCufsCollection) {
            this.toPrintableCuf(tagCuf, result, html);
        }
        for (Cuf rtfCuf : rtfCufsCollection) {
            this.toPrintableCuf(rtfCuf, result, html);
        }
        return result;
    }

    public void toPrintableCuf(Cuf cuf, Collection<PrintableCuf> resultList, List<String> html) {
        PrintableCuf printableCufBean = new PrintableCuf();
        printableCufBean.setLabel(this.evaluateExpressionToString(cuf.getLabel()));
        printableCufBean.setType(this.evaluateExpressionToString(cuf.getType()));
        printableCufBean.setRichText(printableCufBean.isRichText());
        printableCufBean.setEntityId(this.evaluateExpressionToLong(cuf.getEntityId()));
        if (printableCufBean.isRichText()) {
            printableCufBean.setRichTextValue(this.richTextReplace(cuf.getValue(), html));
        } else {
            printableCufBean.setValue(cuf.getValue());
        }
        resultList.add(printableCufBean);
    }

    public String richTextReplace(String string, List<String> html) {
        if ((string = this.encodeSpecialChars(string)).contains("img")) {
            string = this.findAndReplaceImageHeightWidthValue(string);
        }
        if (string.contains("/attachments/download/")) {
            Pattern pattern = Pattern.compile("<img.*?src=([\"'])?(?<src>(?:(?!\\2)[^\"'])+attachments\\/download\\/(?<id>\\d+)([^\"'])?).*?>");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String src = matcher.group("src");
                String id = matcher.group("id");
                String str = this.attachmentImageHelper.getImageBase64String(Long.valueOf(Long.parseLong(id)));
                if (str.isBlank()) continue;
                string = string.replace(src, "data:image/png;base64," + str);
            }
        }
        StringBuilder sb = new StringBuilder(string);
        sb.insert(0, "<html>");
        sb.append("</html>");
        String newVal = "<w:altChunk r:id='toto" + html.size() + "'/>";
        html.add(sb.toString());
        return newVal;
    }

    private String encodeSpecialChars(String richText) {
        return richText.replace("\u201c", "&ldquo;").replace("\u201d", "&rdquo;").replace("\u2019", "&rsquo;").replaceAll("<h\\d\\b[^>]*>", "<p>").replaceAll("</h\\d+>", "</p>");
    }

    public Collection<Cuf> toCufBean(Collection<Object[]> cufsData) {
        ArrayList<Cuf> result = new ArrayList<Cuf>();
        for (Object[] array : cufsData) {
            Cuf cufBean = new Cuf();
            cufBean.setValue(this.evaluateExpressionToString(array[0]));
            cufBean.setLabel(this.evaluateExpressionToString(array[1]));
            cufBean.setType(this.evaluateExpressionToString(array[2]));
            cufBean.setEntityId(this.evaluateExpressionToLong(array[3]));
            result.add(cufBean);
        }
        return result;
    }

    Collection<Cuf> toTagCufBean(Collection<Object[]> tagCufData) {
        ArrayList<Cuf> cufs = new ArrayList<Cuf>();
        for (Object[] row : tagCufData) {
            Cuf cuf = new Cuf();
            if (row[0] != null) {
                String chain = this.evaluateExpressionToString(row[0]).replace(SEPARATOR_PLACEHOLDER, TAG_SEPARATOR);
                cuf.setValue(this.evaluateExpressionToString(chain.substring(0, chain.length() - END_SEPARATOR_PLACEHOLDER.length())));
            } else {
                cuf.setValue(TAG_EMPTY);
            }
            cuf.setLabel(this.evaluateExpressionToString(row[1]));
            cuf.setType(this.evaluateExpressionToString(row[2]));
            cuf.setEntityId(this.evaluateExpressionToLong(row[3]));
            cufs.add(cuf);
        }
        return cufs;
    }

    public Collection<LinkedRequirements> toLinkedRequirementBean(Collection<Object[]> linkedRequirementData) {
        ArrayList<LinkedRequirements> result = new ArrayList<LinkedRequirements>();
        for (Object[] array : linkedRequirementData) {
            LinkedRequirements linkedRequirementsBean = new LinkedRequirements();
            linkedRequirementsBean.setId(this.evaluateExpressionToLong(array[0]));
            linkedRequirementsBean.setName(this.evaluateExpressionToString(array[1]));
            linkedRequirementsBean.setProjectName(this.evaluateExpressionToString(array[2]));
            linkedRequirementsBean.setCriticality(this.evaluateExpressionToString(array[3]));
            linkedRequirementsBean.setStatus(this.evaluateExpressionToString(array[4]));
            linkedRequirementsBean.setVersion(this.evaluateExpressionToLong(array[5]));
            linkedRequirementsBean.setReference(this.evaluateExpressionToString(array[6]));
            linkedRequirementsBean.setTestCaseId(this.evaluateExpressionToLong(array[7]));
            linkedRequirementsBean.setMilestoneNames(this.evaluateExpressionToString(array[8]).replace(",", MILESTONE_SEPARATOR));
            result.add(linkedRequirementsBean);
        }
        return result;
    }

    public Collection<LinkedRequirements> toLinkedRequirementByStepsBean(Collection<Object[]> linkedRequirementData) {
        ArrayList<LinkedRequirements> result = new ArrayList<LinkedRequirements>();
        for (Object[] array : linkedRequirementData) {
            LinkedRequirements linkedRequirementsBean = new LinkedRequirements();
            linkedRequirementsBean.setId(this.evaluateExpressionToLong(array[0]));
            linkedRequirementsBean.setName(this.evaluateExpressionToString(array[1]));
            linkedRequirementsBean.setProjectName(this.evaluateExpressionToString(array[2]));
            linkedRequirementsBean.setReference(this.evaluateExpressionToString(array[3]));
            linkedRequirementsBean.setTestCaseId(this.evaluateExpressionToLong(array[4]));
            linkedRequirementsBean.setCriticality(this.evaluateExpressionToString(array[5]));
            linkedRequirementsBean.setStatus(this.evaluateExpressionToString(array[6]));
            result.add(linkedRequirementsBean);
        }
        return result;
    }

    public Collection<TestCase> toTestCaseBean(Collection<Object[]> testCaseData, boolean printLinkedReq, boolean printParameters, boolean printFolder, boolean printSteps, boolean printMilestones) {
        ArrayList<TestCase> result = new ArrayList<TestCase>();
        for (Object[] array : testCaseData) {
            TestCase testcase = new TestCase();
            testcase.setFolder(this.evaluateExpressionToLong(array[2]));
            testcase.setId(this.evaluateExpressionToLong(array[1]));
            testcase.setName(this.evaluateExpressionToString(array[3]));
            testcase.setLevel(this.evaluateExpressionToLong(array[4]));
            testcase.setImportance(this.evaluateExpressionToString(array[5]));
            testcase.setNature(this.evaluateExpressionToString(array[6]));
            testcase.setType(this.evaluateExpressionToString(array[7]));
            testcase.setNatureType(this.evaluateExpressionToString(array[8]));
            testcase.setTypeType(this.evaluateExpressionToString(array[9]));
            testcase.setStatus(this.evaluateExpressionToString(array[10]));
            testcase.setExecutionMode(this.evaluateExpressionToLong(array[11]));
            testcase.setPrerequisites(this.evaluateExpressionToString(array[12]));
            testcase.setReference(this.evaluateExpressionToString(array[13]));
            testcase.setCreatedOn(this.evaluateExpressionToString(array[14]));
            testcase.setCreatedBy(this.evaluateExpressionToString(array[15]));
            testcase.setLastModifiedOn(this.evaluateExpressionToString(array[16]));
            testcase.setLastModifiedBy(this.evaluateExpressionToString(array[17]));
            testcase.setDescription(this.evaluateExpressionToString(array[18]));
            testcase.setAttachments(this.evaluateExpressionToLong(array[19]));
            String sortingChain = this.evaluateExpressionToString(array[20]).replace(SEPARATOR_PLACEHOLDER, SORTING_CHAIN_SEPARATOR);
            testcase.setSortingChain(HtmlUtils.htmlEscape((String)sortingChain.substring(0, sortingChain.length() - END_SEPARATOR_PLACEHOLDER.length())));
            String milestoneLabels = this.evaluateExpressionToString(array[21]).replace(",", MILESTONE_SEPARATOR);
            testcase.setMilestoneNames(milestoneLabels);
            String nodeIds = this.evaluateExpressionToString(array[22]);
            String[] nodesIds = nodeIds.split(SEPARATOR_PLACEHOLDER);
            ArrayList<Long> hierachyNodes = new ArrayList<Long>();
            String[] stringArray = nodesIds;
            int n = nodesIds.length;
            int n2 = 0;
            while (n2 < n) {
                String node = stringArray[n2];
                hierachyNodes.add(Long.parseLong(node.replace(END_SEPARATOR_PLACEHOLDER, TAG_EMPTY)));
                ++n2;
            }
            testcase.setNodeIds(hierachyNodes);
            if (testcase.getFolder() == 1L) {
                chain = this.evaluateExpressionToString(array[0]).replace(SEPARATOR_PLACEHOLDER, CHAIN_SEPARATOR);
                testcase.setChain(HtmlUtils.htmlEscape((String)chain.substring(0, chain.length() - END_SEPARATOR_PLACEHOLDER.length())));
            } else {
                chain = this.evaluateExpressionToString(array[0]);
                int index = chain.lastIndexOf(SEPARATOR_PLACEHOLDER);
                if (index >= 0) {
                    chain = chain.substring(0, index);
                }
                chain = chain.replace(SEPARATOR_PLACEHOLDER, CHAIN_SEPARATOR);
                testcase.setChain(chain);
            }
            testcase.setScript(this.evaluateExpressionToString(array[23]));
            testcase.setKind(this.evaluateExpressionToString(array[24]));
            testcase.setAllowAutomationWorkflow(this.evaluateExpressionToLong(array[25]));
            testcase.setAutomatable(this.evaluateExpressionToString(array[26]));
            testcase.setRequestStatus(this.evaluateExpressionToString(array[27]));
            testcase.setAutomationPriority(this.evaluateExpressionToString(array[28]));
            testcase.setPrintLinkedReq(printLinkedReq);
            testcase.setPrintParameters(printParameters);
            testcase.setPrintFolder(printFolder);
            testcase.setPrintSteps(printSteps);
            testcase.setPrintMilestones(printMilestones);
            result.add(testcase);
        }
        return result;
    }

    boolean rawMilestoneConfigToBoolean(Collection<Object[]> rawConfigurationData) {
        if (rawConfigurationData.isEmpty()) {
            return false;
        }
        if (rawConfigurationData.size() == 1) {
            Object[] array = rawConfigurationData.iterator().next();
            String value = this.evaluateExpressionToString(array[1]);
            return "true".equalsIgnoreCase(value);
        }
        throw new IndexOutOfBoundsException("bug : sql query results exceed expected quantity, returned: " + rawConfigurationData.size());
    }

    List<Node> toNodesBean(Collection<Object[]> nodesData) {
        ArrayList<Node> nodeBeans = new ArrayList<Node>();
        for (Object[] array : nodesData) {
            Node nodeBean = new Node();
            nodeBean.setProjectId(this.evaluateExpressionToLong(array[0]));
            nodeBean.setProjectName(this.evaluateExpressionToString(array[1]));
            nodeBean.setItemId(this.evaluateExpressionToLong(array[2]));
            nodeBeans.add(nodeBean);
        }
        return nodeBeans;
    }

    Collection<TestCaseSteps> toCallStepBean(Collection<Object[]> objects, Long idTestCase, boolean printAttachments, boolean printLinkedReq, boolean printCufs) {
        ArrayList<TestCaseSteps> result = new ArrayList<TestCaseSteps>();
        for (Object[] array : objects) {
            TestCaseSteps testCaseStepsBean = new TestCaseSteps();
            testCaseStepsBean.setId(this.evaluateExpressionToLong(array[0]));
            testCaseStepsBean.setAction(this.evaluateExpressionToString(array[1]));
            testCaseStepsBean.setExpectedResult(this.evaluateExpressionToString(array[2]));
            testCaseStepsBean.setType(this.evaluateExpressionToString(array[3]));
            testCaseStepsBean.setOrder(this.evaluateExpressionToLong(array[4]));
            testCaseStepsBean.setDataset(this.evaluateExpressionToString(array[5]));
            testCaseStepsBean.setAttach(this.evaluateExpressionToLong(array[6]));
            testCaseStepsBean.setRequirement(this.evaluateExpressionToLong(array[7]));
            testCaseStepsBean.setTestCaseId(this.evaluateExpressionToLong(idTestCase));
            testCaseStepsBean.setPrintAttachments(printAttachments);
            testCaseStepsBean.setPrintCufs(printCufs);
            testCaseStepsBean.setPrintStepLinkedReq(printLinkedReq);
            result.add(testCaseStepsBean);
        }
        return result;
    }

    Collection<Parameter> toParameter(Collection<Object[]> objects) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Object[] array : objects) {
            Parameter parameter = new Parameter();
            parameter.setName(this.evaluateExpressionToString(array[0]));
            parameter.setDescription(this.evaluateExpressionToString(array[1]));
            parameter.setTestCaseId(this.evaluateExpressionToLong(array[2]));
            parameter.setTestCaseSourceName(this.evaluateExpressionToString(array[3]));
            parameter.setTestCaseSourceRef(this.evaluateExpressionToString(array[4]));
            parameter.setTestCaseSourceProjectName(this.evaluateExpressionToString(array[5]));
            parameters.add(parameter);
        }
        return parameters;
    }

    Collection<Dataset> toDataSet(Collection<Object[]> objects) {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        for (Object[] array : objects) {
            Dataset dataset = new Dataset();
            dataset.setId(this.evaluateExpressionToLong(array[0]));
            dataset.setName(this.evaluateExpressionToString(array[1]));
            dataset.setTestCaseId(this.evaluateExpressionToLong(array[2]));
            datasets.add(dataset);
        }
        return datasets;
    }

    Collection<DatasetParamValue> toDataSetParamValue(Collection<Object[]> objects) {
        ArrayList<DatasetParamValue> datasetParamValues = new ArrayList<DatasetParamValue>();
        for (Object[] array : objects) {
            DatasetParamValue datasetParamValue = new DatasetParamValue();
            datasetParamValue.setDataSetId(this.evaluateExpressionToLong(array[0]));
            datasetParamValue.setName(this.evaluateExpressionToString(array[1]));
            datasetParamValue.setValue(this.evaluateExpressionToString(array[2]));
            datasetParamValues.add(datasetParamValue);
        }
        return datasetParamValues;
    }

    public Collection<ActionWordFragmentValueDto> toActionWordFragmentValues(Collection<Object[]> rawBddActionFragments) {
        ArrayList<ActionWordFragmentValueDto> fragmentValues = new ArrayList<ActionWordFragmentValueDto>();
        for (Object[] array : rawBddActionFragments) {
            Long stepId = this.evaluateExpressionToLong(array[0]);
            String value = this.evaluateExpressionToString(array[2]);
            if ("PARAMETER".equals(this.evaluateExpressionToString(array[1]))) {
                fragmentValues.add(new ActionWordParameterValueDto(stepId, value));
                continue;
            }
            fragmentValues.add(new ActionWordTextValueDto(stepId, value));
        }
        return fragmentValues;
    }

    public void bindAll(Collection<TestCaseSteps> testCaseStepsBeans, Collection<LinkedRequirements> linkedRequirementsBeans, Collection<TestCase> testCaseBeans, Collection<LinkedRequirements> linkedRequirementsBySteps, Collection<Parameter> parameters, Collection<Dataset> datasets, Collection<DatasetParamValue> datasetParamValues, Collection<Node> nodes, Collection<PrintableCuf> printCufMap, Collection<PrintableCuf> printTestCaseCufMap) {
        this.tcIdsAlreadyAdd = new ArrayList<Long>();
        this.hierarchyHelper = new TestCaseHierarchyHelper();
        if (!testCaseStepsBeans.isEmpty()) {
            this.bindPrintCufToStep(testCaseStepsBeans, printCufMap);
            this.bindLinkedReqToTestStep(testCaseStepsBeans, linkedRequirementsBySteps);
            this.bindTestStepToTestCase(testCaseBeans, testCaseStepsBeans);
            this.updateStepOrder(testCaseBeans);
        }
        this.bindParamValuesToDataset(datasets, datasetParamValues);
        this.bindDatasetToTestCase(datasets, testCaseBeans);
        this.bindParameterForTestCase(testCaseBeans, parameters);
        this.bindPrintCufToTestCase(testCaseBeans, printTestCaseCufMap);
        if (!linkedRequirementsBeans.isEmpty()) {
            this.bindLinkedReqToTc(testCaseBeans, linkedRequirementsBeans);
        }
        this.bindTestCaseToNode(testCaseBeans, nodes);
    }

    private void updateStepOrder(Collection<TestCase> testCases) {
        for (TestCase testCase : testCases) {
            Long order = 0L;
            for (TestCaseSteps testCaseSteps : testCase.getTcSteps()) {
                testCaseSteps.setOrder(order);
                order = order + 1L;
            }
        }
    }

    private void bindTestCaseToNode(Collection<TestCase> testCaseBeans, Collection<Node> nodeBeans) {
        Optional<Node> firstNodeBean = nodeBeans.stream().findFirst();
        firstNodeBean.ifPresent(node -> {
            String string = this.projectName = node.getProjectName();
        });
        for (Node nodeBean : nodeBeans) {
            List<TestCase> testCaseBeans1 = this.groupTestCaseForNode(testCaseBeans, nodeBean);
            nodeBean.setTestCasesBeans(testCaseBeans1);
        }
    }

    private void bindTestStepToTestCase(Collection<TestCase> testCaseBeans, Collection<TestCaseSteps> testCaseStepsBeans) {
        for (TestCase testCaseBean : testCaseBeans) {
            List<TestCaseSteps> testCaseStepBeanList = this.groupTestStepForTestCase(testCaseStepsBeans, testCaseBean);
            testCaseBean.setTcSteps(testCaseStepBeanList);
        }
    }

    private void bindLinkedReqToTc(Collection<TestCase> testCaseBeans, Collection<LinkedRequirements> linkedRequirementsBeans) {
        for (TestCase testCaseBean : testCaseBeans) {
            List<LinkedRequirements> linkedRequirementsBeanList = this.groupLinkedRequirementForTestCase(linkedRequirementsBeans, testCaseBean);
            testCaseBean.setLinkedRequirements(linkedRequirementsBeanList);
        }
    }

    private void bindLinkedReqToTestStep(Collection<TestCaseSteps> testCaseSteps, Collection<LinkedRequirements> linkedRequirementsBeans) {
        for (TestCaseSteps caseSteps : testCaseSteps) {
            List<LinkedRequirements> linkedRequirementsBeanList = this.groupLinkedRequirementForTestStep(linkedRequirementsBeans, caseSteps);
            caseSteps.setLinkedRequirements(linkedRequirementsBeanList);
        }
    }

    private void bindPrintCufToStep(Collection<TestCaseSteps> testCaseStepsBeans, Collection<PrintableCuf> printableCufCollection) {
        for (TestCaseSteps testCaseStepsBean : testCaseStepsBeans) {
            List<PrintableCuf> testStepPrintCufs = this.groupPrintableCufsForTestSteps(printableCufCollection, testCaseStepsBean);
            testCaseStepsBean.setPrintableCufs(testStepPrintCufs);
        }
    }

    private void bindPrintCufToTestCase(Collection<TestCase> testCaseBeans, Collection<PrintableCuf> printableTestCaseCufCollection) {
        for (TestCase testCaseBean : testCaseBeans) {
            List<PrintableCuf> testCasePrintCufs = this.groupPrintableCufsForTestCases(printableTestCaseCufCollection, testCaseBean);
            testCaseBean.setPrintableCufs(testCasePrintCufs);
        }
    }

    private void bindParameterForTestCase(Collection<TestCase> testCases, Collection<Parameter> parameters) {
        for (TestCase testCase : testCases) {
            List<Parameter> params = this.groupParameterForTestCase(parameters, testCase);
            testCase.setParameters(params);
        }
    }

    private void bindParamValuesToDataset(Collection<Dataset> datasets, Collection<DatasetParamValue> datasetParamValues) {
        for (Dataset dataset : datasets) {
            List<DatasetParamValue> paramValues = this.groupParamValueToDataset(datasetParamValues, dataset);
            dataset.setDatasetParamValues(paramValues);
        }
    }

    private void bindDatasetToTestCase(Collection<Dataset> datasets, Collection<TestCase> testCases) {
        for (TestCase testCase : testCases) {
            List<Dataset> datasetList = this.groupDatasetToTestCase(datasets, testCase);
            testCase.setDatasets(datasetList);
        }
    }

    public List<PrintableCuf> groupPrintableCufsForTestCases(Collection<PrintableCuf> printCufs, TestCase testCaseBean) {
        ArrayList<PrintableCuf> cufs = new ArrayList<PrintableCuf>();
        for (PrintableCuf cuf : printCufs) {
            if (!testCaseBean.acceptAsPrintCuf(cuf)) continue;
            cufs.add(cuf);
        }
        cufs = cufs.stream().sorted(Comparator.comparing(PrintableCuf::getLabel, String::compareToIgnoreCase)).collect(Collectors.toList());
        return cufs;
    }

    public List<TestCase> groupTestCaseForNode(Collection<TestCase> testCaseBeans, Node nodeBean) {
        Iterator<TestCase> iterator = testCaseBeans.iterator();
        ArrayList<TestCase> tc = new ArrayList<TestCase>();
        HashSet<Long> tcIds = new HashSet<Long>();
        while (iterator.hasNext()) {
            TestCase next = iterator.next();
            if (!next.getNodeIds().contains(nodeBean.getItemId())) continue;
            tcIds.addAll(next.getNodeIds());
        }
        for (TestCase testCaseBean : testCaseBeans) {
            if (!tcIds.contains(testCaseBean.getId()) || this.tcIdsAlreadyAdd.contains(testCaseBean.getId())) continue;
            if (!this.projectName.equals(nodeBean.getProjectName())) {
                this.hierarchyHelper = new TestCaseHierarchyHelper();
                this.projectName = nodeBean.getProjectName();
            }
            testCaseBean.setParagraph(this.hierarchyHelper.getNextParagraphLevel(testCaseBean.getLevel().intValue()));
            tc.add(testCaseBean);
            this.tcIdsAlreadyAdd.add(testCaseBean.getId());
        }
        return tc;
    }

    public List<TestCaseSteps> groupTestStepForTestCase(Collection<TestCaseSteps> testCaseStepsBeans, TestCase testCaseBean) {
        Iterator<TestCaseSteps> iterator = testCaseStepsBeans.iterator();
        ArrayList<TestCaseSteps> tc = new ArrayList<TestCaseSteps>();
        while (iterator.hasNext()) {
            TestCaseSteps next = iterator.next();
            if (!testCaseBean.getId().equals(next.getTestCaseId())) continue;
            tc.add(next);
            iterator.remove();
        }
        return tc;
    }

    public List<Parameter> groupParameterForTestCase(Collection<Parameter> parameters, TestCase testCase) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Parameter param : parameters) {
            if (!testCase.getId().equals(param.getTestCaseId())) continue;
            params.add(param);
        }
        return params;
    }

    public List<LinkedRequirements> groupLinkedRequirementForTestCase(Collection<LinkedRequirements> linkedRequirementsBeans, TestCase testCaseBean) {
        Iterator<LinkedRequirements> iterator = linkedRequirementsBeans.iterator();
        ArrayList<LinkedRequirements> linkedRequirementsBeanArrayList = new ArrayList<LinkedRequirements>();
        while (iterator.hasNext()) {
            LinkedRequirements next = iterator.next();
            if (!testCaseBean.getId().equals(next.getTestCaseId())) continue;
            linkedRequirementsBeanArrayList.add(next);
            iterator.remove();
        }
        return linkedRequirementsBeanArrayList;
    }

    public List<LinkedRequirements> groupLinkedRequirementForTestStep(Collection<LinkedRequirements> linkedRequirementsBeans, TestCaseSteps testCaseSteps) {
        ArrayList<LinkedRequirements> linkedRequirementsBeanArrayList = new ArrayList<LinkedRequirements>();
        for (LinkedRequirements linkedRequirements : linkedRequirementsBeans) {
            if (!testCaseSteps.getId().equals(linkedRequirements.getTestCaseId())) continue;
            linkedRequirementsBeanArrayList.add(linkedRequirements);
        }
        return linkedRequirementsBeanArrayList;
    }

    public List<PrintableCuf> groupPrintableCufsForTestSteps(Collection<PrintableCuf> printCufs, TestCaseSteps testCaseStepsBean) {
        return printCufs.stream().filter(testCaseStepsBean::acceptAsPrintCuf).sorted(Comparator.comparing(PrintableCuf::getLabel, String::compareToIgnoreCase)).collect(Collectors.toList());
    }

    private List<DatasetParamValue> groupParamValueToDataset(Collection<DatasetParamValue> datasetParamValues, Dataset dataset) {
        ArrayList<DatasetParamValue> result = new ArrayList<DatasetParamValue>();
        for (DatasetParamValue datasetParamValue : datasetParamValues) {
            if (!dataset.getId().equals(datasetParamValue.getDataSetId())) continue;
            result.add(datasetParamValue);
        }
        return result;
    }

    private List<Dataset> groupDatasetToTestCase(Collection<Dataset> datasets, TestCase testCase) {
        ArrayList<Dataset> result = new ArrayList<Dataset>();
        for (Dataset dataset : datasets) {
            if (!dataset.getTestCaseId().equals(testCase.getId())) continue;
            result.add(dataset);
        }
        return result;
    }

    private String evaluateExpressionToString(Object obj) {
        if (obj instanceof Date) {
            return this.convertDateTimeToString((Date)obj);
        }
        if (this.isStringDate(obj)) {
            return this.formatSimpleDateString(obj.toString());
        }
        return obj != null ? obj.toString() : SORTING_CHAIN_SEPARATOR;
    }

    private boolean isStringDate(Object obj) {
        return obj instanceof String && obj.toString().matches(DATE_REGEX);
    }

    private Locale currentLocale() {
        return LocaleContextHolder.getLocale();
    }

    private String convertDateTimeToString(Date date) {
        return DateFormat.getDateTimeInstance(3, 3, this.currentLocale()).format(date);
    }

    private String formatSimpleDateString(String stringDate) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", this.currentLocale());
            Date date = formatter.parse(stringDate);
            return DateFormat.getDateInstance(3, this.currentLocale()).format(date);
        }
        catch (ParseException parseException) {
            LOGGER.warn("An error occurred when parsing the date string " + stringDate + " . The date will not be converted to local format.");
            return stringDate;
        }
    }

    protected Long evaluateExpressionToLong(Object obj) {
        return Long.valueOf(obj.toString());
    }

    protected boolean evaluateExpressionToBoolean(Object obj) {
        return Boolean.parseBoolean(obj.toString());
    }

    private String findAndReplaceImageHeightWidthValue(String string) {
        String regexPattern = "(?<=\")([0-9]+)(?=\")";
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String stringAttribute = matcher.group();
            int intAttribute = Integer.parseInt(stringAttribute);
            intAttribute = Math.min(intAttribute, 700);
            string = string.replace(stringAttribute, Integer.toString(intAttribute));
        }
        return string;
    }
}

