/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.testcases.beans;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="report.books.testcases.i18nHelper")
public class I18nHelper
implements MessageSourceAware {
    private static MessageSource msgSource;

    private static Locale currentLocale() {
        return LocaleContextHolder.getLocale();
    }

    public static String translate(String string) {
        return msgSource.getMessage(string, null, I18nHelper.currentLocale());
    }

    public static String translate(String string, Object[] params) {
        return msgSource.getMessage(string, params, I18nHelper.currentLocale());
    }

    public static String translateTo(String string, Locale locale) {
        return msgSource.getMessage(string, null, locale);
    }

    public static Locale toLocale(String name) {
        switch (name) {
            case "FRENCH": {
                return new Locale("fr");
            }
            case "GERMAN": {
                return new Locale("de");
            }
            case "SPANISH": {
                return new Locale("es");
            }
        }
        return new Locale("en");
    }

    public void setMessageSource(MessageSource messageSource) {
        msgSource = messageSource;
    }
}

