/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.extract.attachment.tool.engine.jobs.extract;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.batch.item.database.support.H2PagingQueryProvider;
import org.springframework.batch.item.database.support.MySqlPagingQueryProvider;
import org.springframework.batch.item.database.support.PostgresPagingQueryProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.RowMapper;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.Attachment;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.AttachmentItemWriter;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.AttachmentProcessor;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.AttachmentRowMapper;

@Configuration
public class ExtractJobConfig {
    private static final String SELECT_CLAUSE = "SELECT ATTACHMENT_CONTENT_ID, ATTACHMENT_LIST_ID, STREAM_CONTENT, ATTACHMENT_ID ";
    private static final String FROM_CLAUSE = "FROM ATTACHMENT\n  INNER JOIN ATTACHMENT_CONTENT ON ATTACHMENT.CONTENT_ID = ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID ";
    @Autowired
    @Qualifier(value="nonAutoCommitDataSource")
    private DataSource nonAutoCommitDataSource;
    @Autowired
    public JobBuilderFactory jobFactory;
    @Autowired
    public StepBuilderFactory stepBuilderFactory;
    @Autowired
    private Environment environment;

    @Bean
    public Job extractAttachment() {
        return this.jobFactory.get("extractJob").start(this.extractAttachmentStep()).build();
    }

    @Bean
    public Step extractAttachmentStep() {
        return ((StepBuilder)this.stepBuilderFactory.get("extractAttachmentStep").allowStartIfComplete(true)).chunk(10).reader((ItemReader)this.attachmentItemReader()).processor(this.attachmentItemProcessor()).writer((ItemWriter)this.attachmentItemWriter()).build();
    }

    @Bean
    @StepScope
    public JdbcPagingItemReader<Attachment> attachmentItemReader() {
        JdbcPagingItemReader itemReader = new JdbcPagingItemReader();
        itemReader.setDataSource(this.nonAutoCommitDataSource);
        itemReader.setQueryProvider(this.mySqlPagingQueryProvider());
        itemReader.setRowMapper((RowMapper)new AttachmentRowMapper());
        return itemReader;
    }

    @Bean
    public PagingQueryProvider mySqlPagingQueryProvider() {
        MySqlPagingQueryProvider queryProvider;
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        if (activeProfiles.contains("mysql")) {
            queryProvider = new MySqlPagingQueryProvider();
        } else if (activeProfiles.contains("postgresql")) {
            queryProvider = new PostgresPagingQueryProvider();
        } else if (activeProfiles.contains("h2")) {
            queryProvider = new H2PagingQueryProvider();
        } else {
            throw new IllegalArgumentException("Unknown profile " + activeProfiles);
        }
        queryProvider.setSelectClause(SELECT_CLAUSE);
        queryProvider.setFromClause(FROM_CLAUSE);
        queryProvider.setSortKeys(this.sortAttachmentId());
        return queryProvider;
    }

    private Map<String, Order> sortAttachmentId() {
        HashMap<String, Order> sortConfiguration = new HashMap<String, Order>();
        sortConfiguration.put("ATTACHMENT_ID", Order.ASCENDING);
        return sortConfiguration;
    }

    @Bean
    public AttachmentItemWriter attachmentItemWriter() {
        return new AttachmentItemWriter();
    }

    @Bean
    @StepScope
    ItemProcessor<Attachment, Attachment> attachmentItemProcessor() {
        return new AttachmentProcessor();
    }
}

