/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.extract.attachment.tool.engine.jobs.extract;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.Attachment;

public class AttachmentRowMapper
implements RowMapper<Attachment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentRowMapper.class);

    public Attachment mapRow(ResultSet resultSet, int i) throws SQLException {
        Attachment attachment = new Attachment();
        attachment.setAttachmentListId(Long.valueOf(resultSet.getLong("ATTACHMENT_LIST_ID")));
        attachment.setAttachmentContentId(Long.valueOf(resultSet.getLong("ATTACHMENT_CONTENT_ID")));
        byte[] content = this.getContent(resultSet);
        attachment.setContent(content);
        return attachment;
    }

    private byte[] getContent(ResultSet resultSet) throws SQLException, RuntimeException {
        Blob streamContent = resultSet.getBlob("STREAM_CONTENT");
        return streamContent.getBytes(1L, (int)streamContent.length());
    }
}

