/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.extract.attachment.tool.config;

import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.squashtest.tm.extract.attachment.tool.config.DatabaseProperties;
import org.squashtest.tm.extract.attachment.tool.config.SpringBatchSchemaHolder;

@Configuration
@EnableConfigurationProperties(value={DatabaseProperties.class})
public class DatabaseConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseConfig.class);
    @Autowired
    private SpringBatchSchemaHolder schemaHolder;

    @Bean
    @Primary
    public javax.sql.DataSource dataSource(DatabaseProperties databaseProperties) {
        return DataSourceBuilder.create().url(databaseProperties.getUrl()).username(databaseProperties.getUsername()).password(databaseProperties.getPassword()).type(DataSource.class).build();
    }

    @Bean(value={"nonAutoCommitDataSource"})
    public javax.sql.DataSource nonAutoCommitDataSource(DatabaseProperties databaseProperties) {
        javax.sql.DataSource dataSource = DataSourceBuilder.create().url(databaseProperties.getUrl()).username(databaseProperties.getUsername()).password(databaseProperties.getPassword()).type(DataSource.class).build();
        DataSource dataSourceImpl = (DataSource)dataSource;
        dataSourceImpl.setDefaultAutoCommit(Boolean.valueOf(false));
        return dataSource;
    }

    @Bean
    public DataSourceInitializer dataSourceInitializer(javax.sql.DataSource dataSource) {
        LOGGER.info("INIT DB");
        DataSourceInitializer initializer = new DataSourceInitializer();
        initializer.setDataSource(dataSource);
        initializer.setDatabasePopulator(this.databasePopulator());
        return initializer;
    }

    private DatabasePopulator databasePopulator() {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.addScript(this.schemaHolder.getCleanSchema());
        populator.addScript(this.schemaHolder.getPopulateSchema());
        return populator;
    }
}

