/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.squashautom.commons.model.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opentestfactory.jackson.dto.v1.JobDTO;
import org.opentestfactory.messages.AbstractStep;
import org.opentestfactory.messages.Category;
import org.opentestfactory.messages.SquashTFMessage;
import org.squashtest.tf2.squash.testplan.library.application.ParamActionStep;
import org.squashtest.tf2.squash.testplan.library.application.TestCodeCheckoutStep;
import org.squashtest.tf2.squash.testplan.library.application.TestExecutionProviderStep;
import org.squashtest.tf2.squash.testplan.library.model.Credentials;
import org.squashtest.tf2.squash.testplan.library.model.Project;
import org.squashtest.tf2.squash.testplan.library.model.TestExecution;
import org.squashtest.tf2.squash.testplan.library.model.TestPlan;

public class Workflow
extends SquashTFMessage {
    public static final String NAME_METADATA_KEY = "name";
    private Map<String, JobDTO> jobs;

    public Workflow(String apiVersion, String name, TestPlan testPlan) {
        super(apiVersion);
        this.addMetadata(NAME_METADATA_KEY, name);
        HashMap<String, JobDTO> jobMap = new HashMap<String, JobDTO>(testPlan.getProjects().size());
        for (Project project : testPlan.getProjects()) {
            JobDTO job = this.buildJob(project);
            jobMap.put("squashTMJob-" + jobMap.size(), job);
        }
        this.jobs = jobMap;
    }

    public String name() {
        return (String)this.getMetadata().get(NAME_METADATA_KEY);
    }

    private JobDTO buildJob(Project project) {
        ArrayList<AbstractStep> steps = new ArrayList<AbstractStep>();
        Credentials testRepositoryCredentials = project.testRepositoryCredentials;
        steps.add(new TestCodeCheckoutStep(project.testRepository, testRepositoryCredentials, "checkOut"));
        for (TestExecution exec : project.getTests()) {
            if (!exec.getParams().isEmpty()) {
                steps.add(new ParamActionStep(project.toolCategory, exec.getParams(), "paramStepName"));
            }
            steps.add(new TestExecutionProviderStep(exec.getDefinition(), project.toolCategory, exec.getStepId(), "execStepName"));
        }
        Category testToolCategory = new Category(project.toolCategory);
        return new JobDTO(Arrays.asList(testToolCategory.prefix()), steps);
    }

    public Map<String, JobDTO> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }
}

