/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.opentestfactory.messages.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.ClientRuntimeException;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.HttpPostRequest;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.MessageRefusedException;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.Request;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.RequestConfigurationFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.Response;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.SquashAutomWorkflowClient;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.UnexpectedServerResponseException;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.json.codec.ObjectMapperFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.model.messages.Workflow;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.model.messages.WorkflowHandle;

public class SquashAutomWorkflowClientImpl
implements SquashAutomWorkflowClient,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashAutomWorkflowClientImpl.class);
    private final String receptionEndpoint;
    private final String authToken;

    public SquashAutomWorkflowClientImpl(String receptionEndpoint, String authToken) {
        this.receptionEndpoint = receptionEndpoint;
        this.authToken = authToken;
    }

    @Override
    public WorkflowHandle launch(Workflow workflow) throws MessageRefusedException {
        return this.performJsonRESTCall(workflow, String.valueOf(this.receptionEndpoint) + "/workflows");
    }

    protected WorkflowHandle performJsonRESTCall(Workflow workflow, String endpoint) throws MessageRefusedException {
        try {
            URI methodURI = new URI(endpoint);
            Request request = this.createRequest(methodURI, workflow);
            if (StringUtils.isEmpty((CharSequence)this.authToken)) {
                LOGGER.debug("No authentication token, sending anonymously");
            } else {
                request.addHeader((Header)new BasicHeader("Authorization", "Bearer " + this.authToken));
            }
            Response r = request.execute();
            return this.handleResponse(r, methodURI);
        }
        catch (IOException | URISyntaxException ex) {
            throw new ClientRuntimeException("Failed to manage REST call for technical reasons", ex);
        }
    }

    private Request createRequest(URI endpoint, Workflow workflow) throws JsonProcessingException {
        String payload = ObjectMapperFactory.getJsonObjectMapper().writeValueAsString((Object)workflow);
        HttpPost request = new HttpPost(endpoint);
        request.setConfig(new RequestConfigurationFactory().getRequestConfig(endpoint));
        request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        return new HttpPostRequest(request);
    }

    private WorkflowHandle handleResponse(Response resp, URI endPoint) throws IOException, MessageRefusedException {
        try {
            if (resp.getStatusLine().getStatusCode() >= 400) {
                if (this.sameMimeType(resp)) {
                    Status s = (Status)ObjectMapperFactory.getJsonObjectMapper().readValue(resp.getEntity().getContent(), Status.class);
                    throw new MessageRefusedException(s);
                }
                throw new UnexpectedServerResponseException(endPoint, resp.getStatusLine());
            }
            WorkflowHandle workflowHandle = (WorkflowHandle)ObjectMapperFactory.getJsonObjectMapper().readValue(resp.getEntity().getContent(), WorkflowHandle.class);
            return workflowHandle;
        }
        finally {
            resp.getEntity().getContent().close();
        }
    }

    private boolean sameMimeType(Response resp) {
        String refCtString = ContentType.APPLICATION_JSON.getMimeType();
        String actualCTString = resp.mimeType();
        return refCtString.equals(actualCTString);
    }
}

