/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.opentestfactory.messages.SquashTFMessage;
import org.opentestfactory.messages.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.ClientRuntimeException;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.HttpPostRequest;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.MessageRefusedException;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.Request;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.RequestConfigurationFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.Response;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.SquashAutomBusClient;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.UnexpectedServerResponseException;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.json.codec.ObjectMapperFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.model.messages.PublicationStatus;

public class SquashAutomBusClientImpl
implements SquashAutomBusClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashAutomBusClientImpl.class);
    private final String busEndpoint;
    private final String authToken;

    public SquashAutomBusClientImpl(String busEndpoint, String authToken) {
        this.busEndpoint = busEndpoint;
        this.authToken = authToken;
    }

    @Override
    public PublicationStatus publish(SquashTFMessage event) throws MessageRefusedException {
        return this.performJsonRESTCall(event, String.valueOf(this.busEndpoint) + "/publications");
    }

    protected PublicationStatus performJsonRESTCall(SquashTFMessage event, String endpoint) throws MessageRefusedException {
        try {
            URI methodURI = new URI(endpoint);
            Request request = this.createRequest(methodURI, event);
            if (StringUtils.isEmpty((CharSequence)this.authToken)) {
                LOGGER.debug("No authentication token, sending anonymously");
            } else {
                request.addHeader((Header)new BasicHeader("Authorization", "Bearer " + this.authToken));
            }
            Response r = request.execute();
            return this.handleResponse(r, methodURI);
        }
        catch (IOException | URISyntaxException ex) {
            throw new ClientRuntimeException("Failed to manage REST call for technical reasons", ex);
        }
    }

    private Request createRequest(URI endpoint, SquashTFMessage event) throws JsonProcessingException {
        String payload = ObjectMapperFactory.getJsonObjectMapper().writeValueAsString((Object)event);
        HttpPost request = new HttpPost(endpoint);
        request.setConfig(new RequestConfigurationFactory().getRequestConfig(endpoint));
        request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        return new HttpPostRequest(request);
    }

    private PublicationStatus handleResponse(Response resp, URI endPoint) throws IOException, MessageRefusedException {
        try {
            if (resp.getStatusLine().getStatusCode() >= 400) {
                if (this.sameMimeType(resp)) {
                    Status s = (Status)ObjectMapperFactory.getJsonObjectMapper().readValue(resp.getEntity().getContent(), Status.class);
                    throw new MessageRefusedException(s);
                }
                throw new UnexpectedServerResponseException(endPoint, resp.getStatusLine());
            }
            PublicationStatus publicationStatus = (PublicationStatus)ObjectMapperFactory.getJsonObjectMapper().readValue(resp.getEntity().getContent(), PublicationStatus.class);
            return publicationStatus;
        }
        finally {
            resp.getEntity().getContent().close();
        }
    }

    private boolean sameMimeType(Response resp) {
        String refCtString = ContentType.APPLICATION_JSON.getMimeType();
        String actualCTString = resp.mimeType();
        return refCtString.equals(actualCTString);
    }
}

