/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tf2.squash.testplan.library.application;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opentestfactory.jackson.dto.v1.ProviderStep;
import org.squashtest.tf2.squash.testplan.library.application.MessageBuildException;
import org.squashtest.tf2.squash.testplan.library.model.Credentials;
import org.squashtest.tf2.squash.testplan.library.model.CredentialsType;
import org.squashtest.tf2.squash.testplan.library.model.SourceVersion;

public class TestCodeCheckoutStep
extends ProviderStep {
    public TestCodeCheckoutStep(SourceVersion sourceVersion, Credentials credentials, String stepName) {
        super("action/checkout@v2", TestCodeCheckoutStep.addRepositoryParms(sourceVersion, credentials), stepName);
    }

    private static Map<String, Object> addRepositoryParms(SourceVersion sourceVersion, Credentials credentials) {
        HashMap<String, Object> uses = new HashMap<String, Object>();
        URL url = TestCodeCheckoutStep.buildEmittedURL(sourceVersion, credentials);
        uses.put("repository", Objects.requireNonNull(url, "Repository URL is mandatory"));
        uses.put("ref", sourceVersion.refName);
        return uses;
    }

    private static URL buildEmittedURL(SourceVersion sourceVersion, Credentials credentials) {
        try {
            URL url = sourceVersion.url;
            if (credentials != null) {
                String userInfo;
                String encodedSecret = URLEncoder.encode(credentials.secret, "UTF-8");
                if (credentials.type == CredentialsType.BASIC_AUTH) {
                    String encodedUsername = URLEncoder.encode(credentials.username, "UTF-8");
                    userInfo = encodedUsername + ":" + encodedSecret;
                } else {
                    userInfo = ":" + encodedSecret;
                }
                String portSpec = url.getPort() > 0 ? ":" + url.getPort() : "";
                String urlSpec = url.getProtocol() + "://" + userInfo + "@" + url.getHost() + portSpec + url.getPath();
                url = new URL(urlSpec);
            }
            return url;
        }
        catch (UnsupportedEncodingException | MalformedURLException urlExc) {
            throw new MessageBuildException("Failed to build checkout URL", urlExc);
        }
    }
}

