/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tf2.commons;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentestfactory.jackson.dto.v1.EventDtoBase;
import org.opentestfactory.messages.SquashTFMessage;
import org.squashtest.tf2.commons.ObjectUtils;
import org.squashtest.tf2.commons.TestExecutionDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExpectedSuiteDefinition
extends SquashTFMessage
implements EventDtoBase {
    private Map<String, Object> with;

    public ExpectedSuiteDefinition(@JsonProperty(value="apiVersion") String apiVersion, @JsonProperty(value="with") Map<String, Object> with) {
        super(apiVersion);
        this.with = with;
    }

    public String squashTMUrl() {
        if (this.getWith().containsKey("squashTMUrl")) {
            return this.getWith().get("squashTMUrl").toString();
        }
        return null;
    }

    public String automatedServerLogin() {
        if (this.getWith().containsKey("automatedServerLogin")) {
            return this.getWith().get("automatedServerLogin").toString();
        }
        return null;
    }

    public String automatedServerPassword() {
        if (this.getWith().containsKey("automatedServerPassword")) {
            return this.getWith().get("automatedServerPassword").toString();
        }
        return null;
    }

    public String suiteId() {
        if (this.getWith().containsKey("suiteId")) {
            return this.getWith().get("suiteId").toString();
        }
        return null;
    }

    public List<TestExecutionDTO> testExecutions() {
        if (this.getWith().containsKey("testExecutions")) {
            List execList = (List)this.getWith().get("testExecutions");
            return execList.stream().map(exec -> new TestExecutionDTO((String)exec.get("testDefinition"), (String)exec.get("stepId"), (String)exec.get("testId"), (String)exec.get("testTechnology"))).collect(Collectors.toList());
        }
        return new ArrayList<TestExecutionDTO>();
    }

    @Override
    public String getKind() {
        return "ExpectedSuiteDefinition";
    }

    public String workflowId() {
        return (String)this.getMetadata().get("workflow_id");
    }

    public String name() {
        return (String)this.getMetadata().get("name");
    }

    public String jobId() {
        return (String)this.getMetadata().get("job_id");
    }

    public List<String> jobOrigin() {
        return (List)this.getMetadata().get("job_origin");
    }

    public Map<String, Object> getWith() {
        return Collections.unmodifiableMap(ObjectUtils.nonNullOrElse(this.with, Collections.emptyMap()));
    }
}

