/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.messages;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opentestfactory.messages.SquashTFMessage;

public class WorkflowCanceled
extends SquashTFMessage {
    private static final String NAME_KEY = "name";
    private static final String WORKFLOW_ID_KEY = "workflow_id";
    private Map<String, Object> details;

    public WorkflowCanceled(String apiVersion, String name, String workflowId) {
        this(apiVersion, name, workflowId, Collections.emptyMap());
    }

    public WorkflowCanceled(String apiVersion, String name, String workflowId, Map<String, Object> details) {
        super(apiVersion);
        this.addMetadata(NAME_KEY, name);
        this.addMetadata(WORKFLOW_ID_KEY, workflowId);
        this.details = Objects.requireNonNull(details, "Details may not be null (use an empty collection or the alternate constructor to omit details)");
    }

    public String name() {
        return (String)this.getMetadata().get(NAME_KEY);
    }

    public String workflowId() {
        return (String)this.getMetadata().get(WORKFLOW_ID_KEY);
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }
}

