/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.messages;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class SquashTFMessage {
    private Map<String, Object> metadata = new HashMap<String, Object>();
    public final String apiVersion;

    public SquashTFMessage(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getKind() {
        return this.getClass().getSimpleName();
    }

    public void checkKind(String kind) {
        if (!this.getKind().equals(kind)) {
            throw new IllegalArgumentException("Wrong kind " + kind + " for model object of kind " + this.getKind());
        }
    }

    public Object addMetadata(String key, Object value) {
        return this.metadata.put(key, value);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = new HashMap<String, Object>(metadata);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.metadata);
        hash = 37 * hash + Objects.hashCode(this.apiVersion);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SquashTFMessage other = (SquashTFMessage)obj;
        if (!Objects.equals(this.apiVersion, other.apiVersion)) {
            return false;
        }
        return Objects.equals(this.metadata, other.metadata);
    }
}

