/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.messages;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opentestfactory.messages.Category;

public class Selector {
    public final String matchKind;
    public final Map<String, String> matchLabels;
    public final Map<String, String> matchFields;

    protected Selector(String matchKind, Map<String, String> matchLabels, Map<String, String> matchFields) {
        this.matchKind = matchKind;
        this.matchLabels = matchLabels;
        this.matchFields = matchFields;
    }

    public static Selector matchKindSelector(String kind) {
        return new Selector(null, null, null).withMatchKind(kind);
    }

    public static Selector matchLabelsSelector(String label, String value) {
        return new Selector(null, null, null).withMatchLabel(label, value);
    }

    public static Selector matchFieldSelector(String field, String value) {
        return new Selector(null, null, null).withMatchField(field, value);
    }

    public static Selector withCategorySelector(Category c) {
        return new Selector(null, null, null).withCategory(c);
    }

    public Selector withMatchKind(String kind) {
        return new Selector(Objects.requireNonNull(kind, "kind may not be null for matchKindSelector"), this.matchLabels, this.matchFields);
    }

    public Selector withMatchLabel(String label, String value) {
        HashMap<String, String> newMatchLabels = this.copyOrCreateMatchMap(this.matchLabels);
        newMatchLabels.put(Objects.requireNonNull(label, "Label is mandatory for matchLabel selector"), Objects.requireNonNull(value, "Value is mandatory for matchLabel selector"));
        return new Selector(this.matchKind, newMatchLabels, this.matchFields);
    }

    public Selector withMatchField(String field, String value) {
        HashMap<String, String> newMatchFields = this.copyOrCreateMatchMap(this.matchFields);
        newMatchFields.put(Objects.requireNonNull(field, "Field is mandatory for matchField selector"), Objects.requireNonNull(value, "Value is mandatory for matchField selector"));
        return new Selector(this.matchKind, this.matchLabels, newMatchFields);
    }

    public Selector withCategory(Category category) {
        return category.addToSelector(this);
    }

    private HashMap<String, String> copyOrCreateMatchMap(Map<String, String> matchMap) {
        if (matchMap == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(matchMap);
    }
}

