/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.messages;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opentestfactory.messages.WorkflowEvent;

public class ExecutionError
extends WorkflowEvent {
    private static final String NAME_KEY = "name";
    private static final String WORKFLOW_ID_KEY = "workflow_id";
    private Map<String, Object> details;

    public ExecutionError(String apiVersion, String name, String workflowId) {
        this(apiVersion, name, workflowId, Collections.emptyMap());
    }

    public ExecutionError(String apiVersion, String name, String workflowId, Map<String, Object> details) {
        super(apiVersion);
        this.addMetadata(NAME_KEY, name);
        this.addMetadata(WORKFLOW_ID_KEY, workflowId);
        this.details = Objects.requireNonNull(details, "Details may not be null (use an empty collection or the alternate constructor to omit details)");
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public String toString() {
        return "{" + super.toString() + ",details=" + this.details.toString() + "}";
    }
}

