/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.squashautom.commons;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.squashtest.csp.core.bugtracker.core.ConnectorUtils;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.BuildDef;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.StartTestExecution;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.BusClientFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.WorkflowClientFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.optimizer.ParamMapOptimizer;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.testautomation.TestAutomationCallbackService;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationServerNoCredentialsException;

@Service(value="plugin.testautomation.squashautom.connector")
public class TestAutomationSquashAutomConnector
implements TestAutomationConnector {
    private static final String CONNECTOR_KIND = "squashAutom";
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private MessageSource i18nHelper;
    @Inject
    private CallbackUrlProvider callbackUrlProvider;
    @Inject
    private ParamMapOptimizer paramMapOptimizer;
    private BusClientFactory busClientFactory = new BusClientFactory();
    private WorkflowClientFactory workflowClientFactory = new WorkflowClientFactory();

    private String getMessage(String i18nKey) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.i18nHelper.getMessage(i18nKey, null, locale);
    }

    public String getConnectorKind() {
        return CONNECTOR_KIND;
    }

    public boolean checkCredentials(TestAutomationServer testAutomationServer, String login, String password) {
        throw new UnsupportedOperationException();
    }

    public boolean checkCredentials(TestAutomationServer testAutomationServer, Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer testAutomationServer, String s, String s1) {
        throw new UnsupportedOperationException();
    }

    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer testAutomationServer, Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    public Collection<AutomatedTest> listTestsInProject(TestAutomationProject testAutomationProject, String username) {
        throw new UnsupportedOperationException();
    }

    public void executeParameterizedTests(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> tests, String externalId, TestAutomationCallbackService testAutomationCallbackService) {
        throw new UnsupportedOperationException();
    }

    public void executeParameterizedTestsBasedOnITPICollection(Collection<Couple<IterationTestPlanItem, Map<String, Object>>> tests, String suiteId, TestAutomationCallbackService testAutomationCallbackService) {
        MultiValueMap<TestAutomationServer, Couple<IterationTestPlanItem, Map<String, Object>>> itemsByServer = this.reduceToParamdItemsByServer(tests);
        List<BuildDef> buildDefList = this.mapToBuildDef(itemsByServer);
        String callbackUrl = this.callbackUrlProvider.getCallbackUrl().toExternalForm();
        Authentication authentication = this.getUserAuthentication();
        String credential = (String)authentication.getCredentials();
        for (BuildDef buildDef : buildDefList) {
            new StartTestExecution(this.paramMapOptimizer, buildDef, suiteId, callbackUrl, authentication.getName(), credential, this.workflowClientFactory, this.busClientFactory).run();
        }
    }

    public URL findTestAutomationProjectURL(TestAutomationProject testAutomationProject) {
        throw new UnsupportedOperationException();
    }

    public boolean testListIsOrderGuaranteed(Collection<AutomatedTest> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean supports(AuthenticationProtocol authenticationProtocol) {
        return ConnectorUtils.supports((AuthenticationProtocol[])this.getSupportedProtocols(), (AuthenticationProtocol)authenticationProtocol);
    }

    public AuthenticationProtocol[] getSupportedProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.TOKEN_AUTH};
    }

    private MultiValueMap<TestAutomationServer, Couple<IterationTestPlanItem, Map<String, Object>>> reduceToParamdItemsByServer(Collection<Couple<IterationTestPlanItem, Map<String, Object>>> tests) {
        LinkedMultiValueMap itemsByServer = new LinkedMultiValueMap();
        for (Couple<IterationTestPlanItem, Map<String, Object>> paramdItem : tests) {
            itemsByServer.add((Object)((IterationTestPlanItem)paramdItem.getA1()).getReferencedTestCase().getProject().getTestAutomationServer(), paramdItem);
        }
        return itemsByServer;
    }

    private List<BuildDef> mapToBuildDef(MultiValueMap<TestAutomationServer, Couple<IterationTestPlanItem, Map<String, Object>>> itemsByServer) {
        ArrayList<BuildDef> jobDefs = new ArrayList<BuildDef>(itemsByServer.size());
        for (Map.Entry entry : itemsByServer.entrySet()) {
            TestAutomationServer automationServer = (TestAutomationServer)entry.getKey();
            TokenAuthCredentials credentials = this.getAutomationServerCredentials(automationServer);
            jobDefs.add(new BuildDef((TestAutomationServer)entry.getKey(), credentials, (List)entry.getValue()));
        }
        return jobDefs;
    }

    private TokenAuthCredentials getAutomationServerCredentials(TestAutomationServer automationServer) {
        Supplier<TestAutomationServerNoCredentialsException> throwIfNull;
        Optional maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)automationServer);
        Credentials credentials = (Credentials)maybeCredentials.orElseThrow(throwIfNull = () -> {
            throw new TestAutomationServerNoCredentialsException(String.format(this.getMessage("message.testAutomationServer.noCredentials"), automationServer.getName()));
        });
        AuthenticationProtocol protocol = credentials.getImplementedProtocol();
        if (!this.supports(protocol)) {
            throw new UnsupportedAuthenticationModeException(protocol.toString());
        }
        return (TokenAuthCredentials)credentials;
    }

    Authentication getUserAuthentication() {
        return UserContextHolder.getAuthentication();
    }
}

