/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.testautomation.squashautom.commons;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentestfactory.messages.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.squashtest.tf2.commons.ExpectedSuiteDefinition;
import org.squashtest.tf2.squash.testplan.library.model.TestPlan;
import org.squashtest.tf2.squash.testplan.library.model.testspecs.Test;
import org.squashtest.tf2.squash.testplan.library.model.testspecs.TestSuite;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.BuildDef;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.BusClientFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.MessageRefusedException;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.SquashAutomBusClient;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.SquashAutomWorkflowClient;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.httpclient.WorkflowClientFactory;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.model.messages.ExecutionError;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.model.messages.PublicationStatus;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.model.messages.Workflow;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.model.messages.WorkflowHandle;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.optimizer.ParamMapOptimizer;
import org.squashtest.tm.plugin.testautomation.squashautom.commons.resultpublisher.ExpectedSuiteDefinitionBuilder;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;

public class StartTestExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTestExecution.class);
    private static final String API_VERSION = "opentestfactory.org/v1alpha1";
    private static final String EXECUTION_ERROR_NAME = "Failed.squashAutomExecution";
    private static final String WORKFLOW_NAME_FORMAT = "Workflow for Squash TM Suite with id %s";
    private final BuildDef buildDef;
    private final String suiteId;
    private final String callbackUrl;
    private final String automServerUserLogin;
    private final String automServerUserPassword;
    private final SquashAutomWorkflowClient workflowClient;
    private final SquashAutomBusClient busClient;
    private final ParamMapOptimizer paramMapOptimizer;

    public StartTestExecution(ParamMapOptimizer paramMapOptimizer, BuildDef buildDef, String suiteId, String callbackUrl, String automServerUserLogin, String automServerUserPassword, WorkflowClientFactory workflowClientFactory, BusClientFactory busClientFactory) {
        this.paramMapOptimizer = paramMapOptimizer;
        this.buildDef = buildDef;
        this.suiteId = suiteId;
        this.workflowClient = workflowClientFactory.getClient(buildDef.getServer().getUrl(), buildDef.getCredentials().getToken());
        this.busClient = busClientFactory.getClient(this.getBusUrl(buildDef.getServer().getUrl()), buildDef.getCredentials().getToken());
        this.callbackUrl = callbackUrl;
        this.automServerUserLogin = automServerUserLogin;
        this.automServerUserPassword = automServerUserPassword;
    }

    public void run() {
        try {
            TestPlan testPlan = this.createTestPlan();
            Workflow workflow = this.createWorkflow(testPlan);
            String workflowId = this.launchWorkflow(workflow);
            this.transmitExpectedSuiteData(workflowId, testPlan, workflow, this.callbackUrl, this.automServerUserLogin, this.automServerUserPassword);
        }
        catch (Exception ex) {
            throw new TestAutomationException(ex.getMessage(), (Throwable)ex);
        }
    }

    private Workflow createWorkflow(TestPlan testPlan) {
        String workflowName = String.format(WORKFLOW_NAME_FORMAT, this.suiteId);
        return new Workflow(API_VERSION, workflowName, testPlan);
    }

    private TestPlan createTestPlan() {
        TestPlan testPlan = new TestPlan();
        testPlan.setSuiteId(this.suiteId);
        List<Test> tests = this.createTestList();
        testPlan.setTestSuite(new TestSuite(tests));
        return testPlan;
    }

    private List<Test> createTestList() {
        return this.buildDef.getParameterizedItems().stream().map(couple -> {
            Test test = new Test();
            test.setId(((IterationTestPlanItem)couple.getA1()).getId().toString());
            Map<String, String> optimizedForPluginVersionMap = this.paramMapOptimizer.optimizeParamMap((Map)couple.getA2());
            test.setParam(optimizedForPluginVersionMap);
            return test;
        }).collect(Collectors.toList());
    }

    private String launchWorkflow(Workflow workflow) throws MessageRefusedException {
        WorkflowHandle wfHandle = this.workflowClient.launch(workflow);
        String workflowStartLog = "Workflow '" + workflow.name() + "' sent and received with workflow_id '" + wfHandle.getWorkflowId() + "'";
        LOGGER.info(workflowStartLog);
        return wfHandle.getWorkflowId();
    }

    private void transmitExpectedSuiteData(String workflowId, TestPlan plan, Workflow workflow, String callbackUrl, String automServerUserLogin, String automServerUserPassword) throws MessageRefusedException {
        ExpectedSuiteDefinitionBuilder suiteDefBuilder = new ExpectedSuiteDefinitionBuilder();
        ExpectedSuiteDefinition suiteDefinition = suiteDefBuilder.buildExpectedSuiteData(plan, workflowId, workflow, callbackUrl, automServerUserLogin, automServerUserPassword);
        PublicationStatus publicationResult = this.busClient.publish(suiteDefinition);
        if (publicationResult.getStatus() == Status.StatusValue.Failure) {
            LOGGER.error("Failed to publish AutomatedSuite definition for generator {} in workflow {} : {}, {}", new Object[]{workflow.name(), workflowId, publicationResult.getReason(), publicationResult.getDetails()});
            HashMap<String, Object> details = new HashMap<String, Object>(publicationResult.getDetails());
            details.put("publisher.error", "failed to publish ExpectedSuite definition.");
            this.busClient.publish(new ExecutionError(API_VERSION, EXECUTION_ERROR_NAME, workflowId, details));
        } else {
            LOGGER.info("Successfully published AutomatedSuite definition for workflow {}", (Object)workflowId);
        }
    }

    private String getBusUrl(String receptionnistUrl) {
        return UriComponentsBuilder.fromHttpUrl((String)receptionnistUrl).port("38368").toUriString();
    }
}

