/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tf2.squash.testplan.library.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tf2.commons.TestExecutionDTO;
import org.squashtest.tf2.squash.testplan.library.model.Credentials;
import org.squashtest.tf2.squash.testplan.library.model.InvalidTestPlanException;
import org.squashtest.tf2.squash.testplan.library.model.Project;
import org.squashtest.tf2.squash.testplan.library.model.SourceVersion;
import org.squashtest.tf2.squash.testplan.library.model.TestExecution;
import org.squashtest.tf2.squash.testplan.library.model.TestToTestExecution;
import org.squashtest.tf2.squash.testplan.library.model.testspecs.Test;
import org.squashtest.tf2.squash.testplan.library.model.testspecs.TestSuite;

public class TestPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPlan.class);
    public static final String TC_SOURCE_CODE_REPOSITORY_URL = "AUTOM_SOURCE_CODE_REPOSITORY_URL";
    private static final String TC_SOURCE_REPOSITORY_BRANCH = "AUTOM_SOURCE_CODE_REPOSITORY_BRANCH";
    public static final String TC_AUTOMATED_TEST_REFERENCE = "AUTOM_AUTOMATED_TEST_REFERENCE";
    public static final String TC_AUTOMATED_TEST_TECHNOLOGY = "AUTOM_AUTOMATED_TEST_TECHNOLOGY_ACTION_PROVIDER_KEY";
    private String suiteId;
    private TestSuite testSuite;
    private List<TestExecutionDTO> testExecutionToTransmit;

    public List<Project> getProjects() {
        SourceVersionMapper sourceVersionMapper = new SourceVersionMapper();
        this.testSuite.getTest().forEach(sourceVersionMapper);
        ProjectBuilder projectBuilder = new ProjectBuilder();
        sourceVersionMapper.sourceVersionMap.forEach(projectBuilder);
        this.testExecutionToTransmit = projectBuilder.testExecutionsToTransmit();
        return projectBuilder.projectList();
    }

    public String getSuiteId() {
        return this.suiteId;
    }

    public void setSuiteId(String suiteId) {
        this.suiteId = suiteId;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setTestSuite(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    public List<TestExecutionDTO> getTestExecutionToTransmit() {
        return this.testExecutionToTransmit;
    }

    private static class ProjectBuilder
    implements BiConsumer<SourceVersion, List<Test>> {
        private List<Project> projectList = new ArrayList<Project>();
        private List<TestExecutionDTO> testExecutionsToTransmit = new ArrayList<TestExecutionDTO>();

        private ProjectBuilder() {
        }

        @Override
        public void accept(SourceVersion sourceVersion, List<Test> testList) {
            List<TestExecution> testRefList = testList.stream().map(new TestToTestExecution()).collect(Collectors.toList());
            String toolCategory = null;
            String testForToolCategory = null;
            Credentials cred = null;
            for (Test t : testList) {
                String testToolCategory = t.getParam().get(TestPlan.TC_AUTOMATED_TEST_TECHNOLOGY);
                if (testToolCategory == null) {
                    throw new InvalidTestPlanException("Missing technology for test " + t.getParam().get(TestPlan.TC_AUTOMATED_TEST_REFERENCE) + " of project " + t.getParam().get(TestPlan.TC_SOURCE_CODE_REPOSITORY_URL));
                }
                if (toolCategory == null) {
                    toolCategory = testToolCategory;
                    testForToolCategory = t.getParam().get(TestPlan.TC_AUTOMATED_TEST_REFERENCE);
                } else if (!toolCategory.equals(testToolCategory)) {
                    throw new InvalidTestPlanException("Inconsistent technology for test project " + t.getParam().get(TestPlan.TC_SOURCE_CODE_REPOSITORY_URL) + " test " + testForToolCategory + " has technology " + toolCategory + " but test " + t.getParam().get(TestPlan.TC_AUTOMATED_TEST_REFERENCE) + " has " + testToolCategory);
                }
                if (cred == null) {
                    cred = t.extractCredentials();
                    continue;
                }
                if (cred.equals(t.extractCredentials())) continue;
                LOGGER.warn("Inconsistent credentials parameters between tests. Only the first one will be used");
            }
            Project project = new Project(sourceVersion, testRefList, toolCategory, cred);
            this.projectList.add(project);
            testRefList.forEach(testExecution -> this.testExecutionsToTransmit.add(new TestExecutionDTO(testExecution.getDefinition(), testExecution.getStepId(), testExecution.getTestId(), project.toolCategory)));
        }

        public List<Project> projectList() {
            return new ArrayList<Project>(this.projectList);
        }

        public List<TestExecutionDTO> testExecutionsToTransmit() {
            return new ArrayList<TestExecutionDTO>(this.testExecutionsToTransmit);
        }
    }

    private class SourceVersionMapper
    implements Consumer<Test> {
        private Map<SourceVersion, List<Test>> sourceVersionMap = new HashMap<SourceVersion, List<Test>>();

        private SourceVersionMapper() {
        }

        public Map<SourceVersion, List<Test>> sourceVersionMap() {
            return new HashMap<SourceVersion, List<Test>>(this.sourceVersionMap);
        }

        @Override
        public void accept(Test test) {
            try {
                String testRepositoryUrl = test.getParam().get(TestPlan.TC_SOURCE_CODE_REPOSITORY_URL);
                String referenceName = test.getParam().get(TestPlan.TC_SOURCE_REPOSITORY_BRANCH);
                SourceVersion sourceVersion = new SourceVersion(new URL(testRepositoryUrl), referenceName);
                if (!this.sourceVersionMap.containsKey(sourceVersion)) {
                    ArrayList<Test> testList = new ArrayList<Test>();
                    testList.add(test);
                    this.sourceVersionMap.put(sourceVersion, testList);
                } else {
                    this.sourceVersionMap.get(sourceVersion).add(test);
                }
            }
            catch (MalformedURLException ex) {
                throw new InvalidTestPlanException("Malformed URL received from Squash TM", ex);
            }
        }
    }
}

