/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tf2.squash.testplan.library.application;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.opentestfactory.jackson.dto.v1.ProviderStep;
import org.opentestfactory.messages.Category;

public class ParamActionStep
extends ProviderStep {
    private static final String PARAMETER_FORMAT = "tm.squashtest.org/params@v1";

    public ParamActionStep(String toolCategory, Map<String, String> testParms, String stepName) {
        super(ParamActionStep.buildParmCategory(toolCategory), ParamActionStep.buildWithMap(testParms), stepName);
    }

    private static String buildParmCategory(String toolCategoryString) {
        Category toolCategory = new Category(toolCategoryString);
        return toolCategory.withCategory("params").toExternalForm();
    }

    private static Map<String, Object> buildWithMap(Map<String, String> testParmMap) {
        HashMap<String, Object> withMap = new HashMap<String, Object>(2);
        withMap.put("data", new Params(Collections.emptyMap(), testParmMap));
        withMap.put("path", UUID.randomUUID().toString());
        withMap.put("format", PARAMETER_FORMAT);
        return withMap;
    }

    static class Params {
        private final Map<String, String> global;
        private final Map<String, String> test;

        private Params(Map<String, String> global, Map<String, String> test) {
            this.global = global;
            this.test = test;
        }

        public Map<String, String> getGlobal() {
            return Collections.unmodifiableMap(this.global);
        }

        public Map<String, String> getTest() {
            return Collections.unmodifiableMap(this.test);
        }
    }
}

