/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.messages;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentestfactory.messages.AbstractStep;
import org.opentestfactory.messages.ProviderStep;
import org.opentestfactory.messages.WorkflowEvent;

public class ProviderCommand
extends WorkflowEvent {
    private ProviderStep step;
    private List<String> runsOn;
    public final Map<String, Object> contexts;

    public ProviderCommand(String apiVersion, ProviderStep step, List<String> runsOn, Map<String, Object> contexts) {
        super(apiVersion);
        this.step = Objects.requireNonNull(step, "step is mandatory");
        this.runsOn = Objects.requireNonNull(runsOn, "runsOn is mandatory");
        this.contexts = Collections.unmodifiableMap(Objects.requireNonNull(contexts, "contexts is mandatory"));
        this.addMetadata("step_origin", Collections.emptyList());
    }

    public String stepId() {
        return this.getMetadata().get("step_id").toString();
    }

    public List<String> stepOrigin() {
        return (List)this.getMetadata().get("step_origin");
    }

    public List<String> runsOn() {
        return Collections.unmodifiableList(this.runsOn);
    }

    public String stepName() {
        return this.step.name;
    }

    public String uses() {
        return this.step.getUses();
    }

    public Map<String, Object> with() {
        return this.step.getWith();
    }

    public AbstractStep getStep() {
        return this.step;
    }
}

