/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.messages;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opentestfactory.messages.AbstractStep;

public class JobDTO {
    public final String name;
    protected List<String> needs;
    private List<String> runsOn;
    protected List<AbstractStep> steps;

    public JobDTO(String jobName, List<AbstractStep> steps, List<String> runsOn) {
        this.name = jobName;
        this.runsOn = runsOn == null ? Collections.emptyList() : runsOn;
        this.steps = Objects.requireNonNull(steps, "steps are mandatory in job.");
    }

    public List<String> getNeeds() {
        return this.needs;
    }

    public Object jsonRunsOn() {
        switch (this.runsOn.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.runsOn.get(0);
            }
        }
        return this.runsOn;
    }

    public List<String> runsOn() {
        return this.runsOn;
    }

    public List<AbstractStep> getSteps() {
        return this.steps;
    }
}

