/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.messages;

import java.util.Collections;
import java.util.List;
import org.opentestfactory.messages.WorkflowEvent;

public class ExecutionResult
extends WorkflowEvent {
    private List<String> attachments;
    private Integer status;
    private List<String> logs;

    public ExecutionResult(String apiVersion, List<String> attachments, Integer status, List<String> logs) {
        super(apiVersion);
        this.attachments = attachments;
        this.status = status;
        this.logs = logs;
    }

    public List getAttachments() {
        if (this.attachments == null) {
            return Collections.emptyList();
        }
        return this.attachments;
    }

    public String stepId() {
        return (String)this.getMetadata().get("step_id");
    }

    public List<String> stepOrigin() {
        return (List)this.getMetadata().get("step_origin");
    }

    public int stepSequenceId() {
        return (Integer)this.getMetadata().get("step_sequence_id");
    }

    public List<String> logs() {
        return Collections.unmodifiableList(this.logs == null ? Collections.emptyList() : this.logs);
    }

    public Integer status() {
        return this.status;
    }

    public String toString() {
        return "ExecutionResult{attachments=" + this.attachments + ", apiVersion='" + this.apiVersion + '\'' + '}';
    }
}

