/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.messages;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentestfactory.messages.Selector;

public class Category {
    public static final String VERSION_LABEL = "opentestfactory.org/categoryVersion";
    public static final String VALUE_LABEL = "opentestfactory.org/category";
    public static final String PREFIX_LABEL = "opentestfactory.org/categoryPrefix";
    public static final String VERSION_GROUP_NAME = "version";
    public static final String NAME_GROUP_NAME = "name";
    public static final String PREFIX_GROUP_NAME = "prefix";
    public static final Pattern FORMAT_PATTERN = Pattern.compile("^(?:(?<prefix>[a-zA-Z.\\-]+)\\/)?(?<name>[a-zA-Z0-9\\-.]+)?(?:@(?<version>[a-zA-Z\\-.0-9]+))?$");
    private final String prefix;
    private final String name;
    private final String version;

    public Category(String categoryDefinition) {
        Pattern categoryFormat = FORMAT_PATTERN;
        Matcher matcher = categoryFormat.matcher(categoryDefinition);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(categoryDefinition + " is not a recognized category definition.");
        }
        this.prefix = matcher.group(PREFIX_GROUP_NAME);
        this.name = matcher.group(NAME_GROUP_NAME);
        this.version = matcher.group(VERSION_GROUP_NAME);
    }

    private Category(String prefix, String name, String version) {
        this.prefix = prefix;
        this.name = name;
        this.version = version;
    }

    public Category withPrefix(String newPrefix) {
        return new Category(newPrefix, this.name, this.version);
    }

    public Category withCategory(String newCategory) {
        return new Category(this.prefix, newCategory, this.version);
    }

    public Category withVersion(String newVersion) {
        return new Category(this.prefix, this.name, newVersion);
    }

    public Selector addToSelector(Selector s) {
        Selector result = s;
        if (this.prefix != null) {
            result = result.withMatchLabel(PREFIX_LABEL, this.prefix);
        }
        if (this.name != null) {
            result = result.withMatchLabel(VALUE_LABEL, this.name);
        }
        if (this.version != null) {
            result = result.withMatchLabel(VERSION_LABEL, this.version);
        }
        return result;
    }

    public String category() {
        return this.name;
    }

    public String prefix() {
        return this.prefix;
    }

    public String version() {
        return this.version;
    }

    public String toExternalForm() {
        return (this.prefix == null ? "" : this.prefix + '/') + (this.name == null ? "" : this.name) + (this.version == null ? "" : '@' + this.version);
    }
}

