/*
 * Decompiled with CFR 0.152.
 */
package org.opentestfactory.jackson.dto.v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentestfactory.jackson.dto.v1.EventDtoBase;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutionResult
extends org.opentestfactory.messages.ExecutionResult
implements EventDtoBase {
    public ExecutionResult(@JsonProperty(value="apiVersion") String apiVersion, @JsonProperty(value="attachments") List<String> attachments, @JsonProperty(value="status") Integer status, @JsonProperty(value="logs") List<String> logs) {
        super(apiVersion, attachments, status, logs);
    }

    public Map<String, AttachmentStatusDTO> attachmentStatus() {
        Map deserializedAttachmentStatusMap = (Map)this.getMetadata().get("attachments");
        if (deserializedAttachmentStatusMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, AttachmentStatusDTO> attachmentStatusMap = new HashMap<String, AttachmentStatusDTO>();
        ObjectMapper mapper = new ObjectMapper();
        for (Map.Entry content : deserializedAttachmentStatusMap.entrySet()) {
            AttachmentStatusDTO attachmentStatusDTO = (AttachmentStatusDTO)mapper.convertValue(content.getValue(), AttachmentStatusDTO.class);
            attachmentStatusMap.put((String)content.getKey(), attachmentStatusDTO);
        }
        return attachmentStatusMap;
    }

    public List<StepStatusDTO> stepOriginStatus() {
        Map stepOriginStatusList = (Map)this.getMetadata().get("step_origin_status");
        if (stepOriginStatusList == null) {
            return Collections.emptyList();
        }
        return stepOriginStatusList.entrySet().stream().map(entry -> new StepStatusDTO((String)entry.getKey(), (Integer)entry.getValue())).collect(Collectors.toList());
    }

    public Integer getNbResult(String stepUuid) {
        Objects.requireNonNull(stepUuid, "Step UUIT cannot be null.");
        Integer nbResult = null;
        for (StepStatusDTO status : this.stepOriginStatus()) {
            if (!stepUuid.equals(status.getStepUuid())) continue;
            nbResult = status.getNbResult();
        }
        return nbResult;
    }

    public static class StepStatusDTO {
        private final String stepUuid;
        private final Integer nbResult;

        public StepStatusDTO(@JsonProperty(value="step_uuid") String stepUuid, @JsonProperty(value="nb_result") Integer nbResult) {
            this.stepUuid = stepUuid;
            this.nbResult = nbResult;
        }

        public String getStepUuid() {
            return this.stepUuid;
        }

        public Integer getNbResult() {
            return this.nbResult;
        }
    }

    public static class AttachmentStatusDTO {
        private String uuid;

        public AttachmentStatusDTO(@JsonProperty(value="uuid") String uuid) {
            this.uuid = uuid;
        }

        public String getUuid() {
            return this.uuid;
        }
    }
}

