/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.BasicResourceAssembler;

public abstract class BaseRestController {
    @Inject
    protected BasePathAwareLinkBuildingService linkService;
    @Inject
    protected PagedResourcesAssembler pageAssembler;
    @Inject
    private BasicResourceAssembler resAssembler;

    protected <ENTITY extends Identified> LinkBuilder fromBasePath(ControllerLinkBuilder builder) {
        return this.linkService.fromBasePath(builder);
    }

    protected <ENTITY extends Identified> Link createSelfLink(ENTITY entity) {
        return this.linkService.createSelfLink(entity);
    }

    protected <ENTITY extends Identified> Link createLinkTo(ENTITY entity) {
        return this.linkService.createLinkTo(entity);
    }

    protected <ENTITY extends Identified> Link createLinkTo(Class<ENTITY> clazz, Long id) {
        return this.linkService.createLinkTo(clazz, id);
    }

    protected <ENTITY extends Identified> Link createRelationTo(String relname) {
        return this.linkService.createRelationRelativeToCurrentUri(relname);
    }

    protected <ENTITY extends Identified> Link createRelationTo(ENTITY entity, String relname) {
        return this.linkService.createRelationTo(entity, relname);
    }

    protected <ENTITY extends Identified> Resource<ENTITY> toResource(ENTITY object) {
        return this.resAssembler.toResource(object);
    }

    protected <T> PagedResources<Resource> toPagedResources(Page page) {
        return this.pageAssembler.toResource(page, (ResourceAssembler)this.resAssembler);
    }

    protected <T> SingleRelPagedResources<Resource> toPagedResourcesWithRel(Page page, String rel) {
        PagedResources res = this.pageAssembler.toResource(page, (ResourceAssembler)this.resAssembler);
        return new SingleRelPagedResources<Resource>(res, rel);
    }
}

