/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.core.LinkBuilderSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.plugin.rest.core.configuration.RestApiProperties;
import org.squashtest.tm.plugin.rest.core.exception.ProgrammingError;
import org.squashtest.tm.plugin.rest.core.utils.ProxyUtils;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UndefinedIdentified;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;

public class BasePathAwareLinkBuildingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePathAwareLinkBuildingService.class);
    private final URI contextBaseURI;
    private final String restBasePath;
    private final ApplicationContext context;
    private Map<Class<? extends Identified>, Method> entityGetterHandlerMap = new HashMap<Class<? extends Identified>, Method>();
    private RelProvider relProvider;
    @Inject
    private CallbackUrlProvider callbackUrlProvider;

    public BasePathAwareLinkBuildingService(ServletContext servletContext, RestApiProperties properties, RelProvider relProvider, ApplicationContext context) {
        this.contextBaseURI = URI.create(servletContext.getContextPath());
        this.restBasePath = properties.getNormalizedBasePath();
        this.context = context;
        this.relProvider = relProvider;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("initializing link building service with base url : " + this.contextBaseURI + this.restBasePath);
        }
    }

    @PostConstruct
    public void afterPropertiesSet() {
        LOGGER.trace("initializing entity getter handler map");
        this.initHandlerMap();
    }

    public LinkBuilder fromBasePath(ControllerLinkBuilder linkBuilder) {
        try {
            URI returnedUri;
            URI linkURI = linkBuilder.toUri();
            URI squashURI = new URI(linkURI.getScheme(), linkURI.getUserInfo(), linkURI.getHost(), linkURI.getPort(), this.contextBaseURI.getPath(), null, null);
            URI relativeLinkUri = squashURI.relativize(linkURI);
            try {
                returnedUri = this.callbackUrlProvider.getCallbackUrl().toURI();
            }
            catch (BadConfiguration badConfiguration) {
                returnedUri = squashURI;
            }
            return ((BasePathLinkBuilder)BasePathLinkBuilder.create(returnedUri).slash(this.restBasePath)).slash(relativeLinkUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public <ENTITY extends Identified> ControllerLinkBuilder initializeBuilderFor(Class<ENTITY> clazz, long id) {
        Method handler = this.findHandlerFor(clazz);
        return ControllerLinkBuilder.linkTo((Method)handler, (Object[])new Object[]{id});
    }

    public <ENTITY extends Identified> ControllerLinkBuilder initializeBuilderFor(ENTITY entity) {
        return this.initializeBuilderFor(ProxyUtils.getClass(entity), entity.getId());
    }

    public <ID extends Identified> Link createLinkTo(Class<ID> clazz, Long id, String relname) {
        return this.fromBasePath(this.initializeBuilderFor(clazz, id)).withRel(relname);
    }

    public <ENTITY extends Identified> Link createLinkTo(ENTITY entity) {
        Class<?> clazz = ProxyUtils.getClass(entity);
        String relname = this.relProvider.getItemResourceRelFor(clazz);
        return this.createLinkTo(clazz, entity.getId(), relname);
    }

    public <ENTITY extends Identified> Link createSelfLink(ENTITY entity) {
        Class<?> clazz = ProxyUtils.getClass(entity);
        return this.createLinkTo(clazz, entity.getId(), "self");
    }

    public <ENTITY extends Identified> Link createSelfLink(Class<ENTITY> clazz, Long id) {
        return this.createLinkTo(clazz, id, "self");
    }

    public <ENTITY extends Identified> Link createLinkTo(ENTITY entity, String relname) {
        Class<?> clazz = ProxyUtils.getClass(entity);
        return this.createLinkTo(clazz, entity.getId(), relname);
    }

    public <ID extends Identified> Link createLinkTo(Class<ID> clazz, Long id) {
        String relname = this.relProvider.getItemResourceRelFor(clazz);
        return this.createLinkTo(clazz, id, relname);
    }

    public <ENTITY extends Identified> Link createRelationRelativeToCurrentUri(String relname) {
        try {
            ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
            builder.path("/" + relname);
            return new Link(builder.toUriString(), relname);
        }
        catch (Exception exception) {
            LOGGER.error("attempted to retrieve the current http request, but it seems this thread isn't processing one");
            return new Link("", relname);
        }
    }

    public <ENTITY extends Identified> Link createRelationTo(ENTITY entity, String relname) {
        return this.fromBasePath(this.initializeBuilderFor(entity)).slash((Object)relname).withRel(relname);
    }

    public <ENTITY extends Identified> Link createRelationTo(Class<ENTITY> entityClass, long id, String relname) {
        return this.fromBasePath(this.initializeBuilderFor(entityClass, id)).slash((Object)relname).withRel(relname);
    }

    public <ENTITY extends Identified> Link createRelationTo(Class<ENTITY> entityClass, long id, String relname, String relpath) {
        return this.fromBasePath(this.initializeBuilderFor(entityClass, id)).slash((Object)relpath).withRel(relname);
    }

    private Method findHandlerFor(Object entity) {
        Class<?> unproxied = ProxyUtils.getClass(entity);
        return this.entityGetterHandlerMap.get(unproxied);
    }

    private Method findHandlerFor(Class<? extends Identified> clazz) {
        Method method = this.entityGetterHandlerMap.get(clazz);
        if (method != null) {
            return method;
        }
        throw new ProgrammingError("Somehow no controller handler could be found for entity class '" + clazz + "'. " + "Please ensure that there is a controller dedicated to that class, with proper " + "use of @RestApiController and @EntityGetter");
    }

    private final void initHandlerMap() {
        Map controllers = this.context.getBeansOfType(BaseRestController.class);
        for (Map.Entry entry : controllers.entrySet()) {
            RestApiController racAnnot;
            Class<? extends Identified> mainType;
            String beanName = (String)entry.getKey();
            BaseRestController controller = (BaseRestController)entry.getValue();
            Class<?> contCls = ProxyUtils.getClass(controller);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("looking for @EntityGetter method on bean '" + beanName + "' of class " + contCls);
            }
            if ((mainType = (racAnnot = (RestApiController)AnnotationUtils.findAnnotation(contCls, RestApiController.class)).value()).equals(UndefinedIdentified.class)) continue;
            Method entityGetter = null;
            Class<? extends Identified>[] subclasses = null;
            Method[] methodArray = contCls.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                EntityGetter annot = (EntityGetter)AnnotationUtils.getAnnotation((Method)m, EntityGetter.class);
                if (annot != null) {
                    entityGetter = m;
                    subclasses = annot.value();
                    break;
                }
                ++n2;
            }
            if (entityGetter != null) {
                this.entityGetterHandlerMap.put(mainType, entityGetter);
                methodArray = subclasses;
                n = subclasses.length;
                n2 = 0;
                while (n2 < n) {
                    Method cls = methodArray[n2];
                    this.entityGetterHandlerMap.put((Class<? extends Identified>)((Object)cls), entityGetter);
                    ++n2;
                }
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("found @EntityGetter on method '" + entityGetter.getName() + "' on class '" + contCls + "', registering as entity getter for entity : '" + mainType + "'");
                if (subclasses.length <= 0) continue;
                StringBuilder builder = new StringBuilder();
                Class<? extends Identified>[] classArray = subclasses;
                int n3 = subclasses.length;
                n = 0;
                while (n < n3) {
                    Class<? extends Identified> cls = classArray[n];
                    builder.append(cls.getName());
                    ++n;
                }
                LOGGER.trace("also registering for subclasses : " + builder);
                continue;
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("could not find @EntityGetter on class ");
        }
    }

    private static final class BasePathLinkBuilder
    extends LinkBuilderSupport<BasePathLinkBuilder> {
        public BasePathLinkBuilder(UriComponentsBuilder builder) {
            super(builder);
        }

        public static BasePathLinkBuilder create(URI baseUri) {
            return new BasePathLinkBuilder(UriComponentsBuilder.fromUri((URI)baseUri));
        }

        protected BasePathLinkBuilder getThis() {
            return this;
        }

        protected BasePathLinkBuilder createNewInstance(UriComponentsBuilder builder) {
            return new BasePathLinkBuilder(builder);
        }
    }
}

