/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.HalConfiguration;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.http.converter.json.SpringHandlerInstantiator;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelHalResourcesSerializer;
import org.squashtest.tm.plugin.rest.core.jackson.ChainConverter;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializeChainConverter;
import org.squashtest.tm.plugin.rest.core.jackson.SerializeChainConverter;

public class SquashRestHalHandlerInstantiator
extends HandlerInstantiator {
    private Map<Class<?>, Object> halHandlerInstantiatorSerializers = new HashMap();
    private final SpringHandlerInstantiator springHandlerInstantiator;

    public SquashRestHalHandlerInstantiator(RelProvider provider, CurieProvider curieProvider, MessageSourceAccessor messageSourceAccessor, AutowireCapableBeanFactory beanFactory) {
        this.springHandlerInstantiator = new SpringHandlerInstantiator(beanFactory);
        Jackson2HalModule.HalHandlerInstantiator halHI = new Jackson2HalModule.HalHandlerInstantiator(provider, curieProvider, messageSourceAccessor, beanFactory, new HalConfiguration().withRenderSingleLinks(HalConfiguration.RenderSingleLinks.AS_SINGLE));
        Jackson2HalModule.HalLinkListSerializer listSer = (Jackson2HalModule.HalLinkListSerializer)halHI.serializerInstance(null, null, Jackson2HalModule.HalLinkListSerializer.class);
        Jackson2HalModule.HalResourcesSerializer resSer = (Jackson2HalModule.HalResourcesSerializer)halHI.serializerInstance(null, null, Jackson2HalModule.HalResourcesSerializer.class);
        this.halHandlerInstantiatorSerializers.put(Jackson2HalModule.HalLinkListSerializer.class, listSer);
        this.halHandlerInstantiatorSerializers.put(Jackson2HalModule.HalResourcesSerializer.class, (Object)new SingleRelHalResourcesSerializer(resSer));
    }

    public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
        if (this.isCustom(deserClass)) {
            return (JsonDeserializer)this.getCustomSerializer(deserClass);
        }
        return this.springHandlerInstantiator.deserializerInstance(config, annotated, deserClass);
    }

    public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
        if (this.isCustom(keyDeserClass)) {
            return (KeyDeserializer)this.getCustomSerializer(keyDeserClass);
        }
        return this.springHandlerInstantiator.keyDeserializerInstance(config, annotated, keyDeserClass);
    }

    public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
        if (this.isCustom(serClass)) {
            return (JsonSerializer)this.getCustomSerializer(serClass);
        }
        return this.springHandlerInstantiator.serializerInstance(config, annotated, serClass);
    }

    public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
        if (this.isCustom(builderClass)) {
            return (TypeResolverBuilder)this.getCustomSerializer(builderClass);
        }
        return this.springHandlerInstantiator.typeResolverBuilderInstance(config, annotated, builderClass);
    }

    public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
        if (this.isCustom(resolverClass)) {
            return (TypeIdResolver)this.getCustomSerializer(resolverClass);
        }
        return this.springHandlerInstantiator.typeIdResolverInstance(config, annotated, resolverClass);
    }

    public VirtualBeanPropertyWriter virtualPropertyWriterInstance(MapperConfig<?> config, Class<?> implClass) {
        if (this.isCustom(implClass)) {
            return (VirtualBeanPropertyWriter)this.getCustomSerializer(implClass);
        }
        return this.springHandlerInstantiator.virtualPropertyWriterInstance(config, implClass);
    }

    public Converter<?, ?> converterInstance(MapperConfig<?> config, Annotated annotated, Class<?> implClass) {
        if (this.isCustom(implClass)) {
            return (Converter)this.getCustomSerializer(implClass);
        }
        if (this.isChainConverter(implClass)) {
            return this.instantiateChainConverter(config, annotated, implClass);
        }
        return this.springHandlerInstantiator.converterInstance(config, annotated, implClass);
    }

    private boolean isChainConverter(Class<?> clazz) {
        return ChainConverter.class.isAssignableFrom(clazz);
    }

    private ChainConverter<?, ?> instantiateChainConverter(MapperConfig<?> config, Annotated annotated, Class<?> implClass) {
        Class<Converter>[] classes;
        ChainConverter converter = (ChainConverter)((Object)ClassUtil.createInstance(implClass, (boolean)config.canOverrideAccessModifiers()));
        SerializeChainConverter serAnnot = (SerializeChainConverter)annotated.getAnnotation(SerializeChainConverter.class);
        DeserializeChainConverter deserAnnot = (DeserializeChainConverter)annotated.getAnnotation(DeserializeChainConverter.class);
        Class<Converter>[] classArray = classes = converter.convertersFrom(serAnnot, deserAnnot);
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<Converter> clz = classArray[n2];
            Converter<?, ?> conv = this.converterInstance(config, annotated, clz);
            converter.addConverter(conv);
            ++n2;
        }
        return converter;
    }

    private boolean isCustom(Class<?> clazz) {
        return this.halHandlerInstantiatorSerializers.containsKey(clazz);
    }

    private <T> T getCustomSerializer(Class<?> clazz) {
        return (T)this.halHandlerInstantiatorSerializers.get(clazz);
    }
}

