/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.ScriptedTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDtoVisitor;
import org.squashtest.tm.plugin.rest.validators.helper.RestNodeValidationHelper;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;

@Component
public class TestCaseDtoValidationHelper
extends RestNodeValidationHelper {
    @Inject
    private InfoListItemFinderService infoListItemFinderService;

    public void checkInvalidAttributeForEachTestCaseType(final Errors errors, final TestCaseDto iTestCase) {
        TestCaseDtoVisitor testCaseDtoVisitor = new TestCaseDtoVisitor(){

            @Override
            public void visit(TestCaseDto testCaseDto) {
            }

            @Override
            public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
                if (iTestCase.getSteps() != null) {
                    errors.rejectValue("steps", "invalid steps", "Script test case should not have steps");
                }
                if (iTestCase.getParameters() != null) {
                    errors.rejectValue("parameters", "invalid parameters", "Script test case should not have parameters");
                }
                if (iTestCase.getDatasets() != null) {
                    errors.rejectValue("datasets", "invalid datasets", "Script test case should not have datasets");
                }
            }

            @Override
            public void visit(KeywordTestCaseDto keywordTestCaseDto) {
            }
        };
        iTestCase.accept(testCaseDtoVisitor);
    }

    public void assignInfoList(Errors errors, TestCaseDto iTestCase) {
        this.checkAndAssignType(errors, iTestCase);
        this.checkAndAssignNature(errors, iTestCase);
    }

    private void checkAndAssignNature(Errors errors, TestCaseDto iTestCase) {
        InfoListItem nature = iTestCase.getNature();
        if (nature != null) {
            String code = nature.getCode();
            Project project = iTestCase.getProject();
            if (project == null) {
                throw new IllegalArgumentException("Programmatic error : You must give a project to a Rest Node to be able to check infolist.");
            }
            if (this.infoListItemFinderService.isNatureConsistent(project.getId().longValue(), code)) {
                iTestCase.setNature(this.infoListItemFinderService.findByCode(code));
            } else {
                errors.rejectValue("nature", "invalid nature", "Invalid test case nature for this project");
            }
        }
    }

    private void checkAndAssignType(Errors errors, TestCaseDto iTestCase) {
        InfoListItem type = iTestCase.getType();
        if (type != null) {
            String code = type.getCode();
            if (this.infoListItemFinderService.isTypeConsistent(iTestCase.getProject().getId().longValue(), code)) {
                iTestCase.setType(this.infoListItemFinderService.findByCode(code));
            } else {
                errors.rejectValue("type", "invalid type", "Invalid test case type for this project");
            }
        }
    }
}

