/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemInfoListItemCode;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.validators.helper.CustomFieldValueValidationHelper;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;

@Component
public class RequirementVersionDtoValidationHelper
extends CustomFieldValueValidationHelper {
    @Inject
    private InfoListItemFinderService infoListItemFinderService;
    @Inject
    private CustomFieldBindingFinderService bindingService;
    @Inject
    private CustomFieldValueHelper customFieldValueHelper;

    public void checkAndAssignValues(Errors errors, RequirementVersionDto iRequirementVersion) {
        this.checkAndAssignStrings(iRequirementVersion);
        this.checkAndAssignCategory(errors, iRequirementVersion);
        this.checkAndAssignCriticality(iRequirementVersion);
    }

    public void checkAndAssignValuesPatch(Errors errors, RequirementVersionDto iRequirementVersion, Requirement requirement) {
        if (iRequirementVersion.isHasReference() && iRequirementVersion.getReference() == null) {
            iRequirementVersion.setReference("");
        }
        if (iRequirementVersion.isHasDescription() && iRequirementVersion.getDescription() == null) {
            iRequirementVersion.setDescription("");
        }
        if (iRequirementVersion.isHasCategory()) {
            this.checkAndAssignCategory(errors, iRequirementVersion);
        }
        if (iRequirementVersion.isHasCriticality()) {
            this.checkAndAssignCriticality(iRequirementVersion);
        }
        if (iRequirementVersion.isHasStatus()) {
            this.checkAndAssignStatus(errors, iRequirementVersion, requirement);
        }
    }

    private void checkAndAssignStrings(RequirementVersionDto iRequirementVersion) {
        if (iRequirementVersion.getDescription() == null) {
            iRequirementVersion.setDescription("");
        }
        if (iRequirementVersion.getReference() == null) {
            iRequirementVersion.setReference("");
        }
    }

    private void checkAndAssignCriticality(RequirementVersionDto iRequirementVersion) {
        RequirementCriticality criticality = iRequirementVersion.getCriticality();
        if (criticality == null) {
            iRequirementVersion.setCriticality(RequirementCriticality.UNDEFINED);
        }
    }

    private void checkAndAssignCategory(Errors errors, RequirementVersionDto iRequirementVersion) {
        InfoListItem category = iRequirementVersion.getCategory();
        if (category != null) {
            String code = category.getCode();
            Long projectId = iRequirementVersion.getProjectId();
            if (projectId == null) {
                errors.rejectValue("category", "invalid projetId", "You must give a project to a Rest Node to be able to check infolist.");
            }
            if (this.infoListItemFinderService.isCategoryConsistent(projectId.longValue(), code)) {
                iRequirementVersion.setCategory(this.infoListItemFinderService.findByCode(code));
            } else {
                errors.rejectValue("category", "invalid category", "Invalid requirement category for this project");
            }
        } else {
            InfoListItem defaultCategory = this.infoListItemFinderService.findByCode(SystemInfoListItemCode.CAT_UNDEFINED.getCode());
            iRequirementVersion.setCategory(defaultCategory);
        }
    }

    public void checkAndAssignStatus(Errors errors, RequirementVersionDto requirementVersionDto, Requirement requirement) {
        RequirementStatus actualStatus = requirement.getStatus();
        if (requirementVersionDto.getStatus() == null) {
            requirementVersionDto.setStatus(RequirementStatus.WORK_IN_PROGRESS);
        }
        if (!actualStatus.getAllowsStatusUpdate() || !actualStatus.isTransitionLegal(requirementVersionDto.getStatus())) {
            errors.rejectValue("status", "invalid status", "Only requirements which have the status 'Under review' can have their status updated to 'Approved'.");
        }
    }

    public void checkCufs(Errors errors, RequirementVersionDto requirementVersionDto) {
        List<CustomFieldValueDto> listCufsDto = requirementVersionDto.getCustomFields();
        this.customFieldValueHelper.checkCufs(errors, BindableEntity.REQUIREMENT_VERSION, requirementVersionDto.getProjectId(), listCufsDto);
    }
}

