/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.plugin.rest.jackson.model.CheckingAttributeTestStepDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.validators.helper.TestStepValidationHelper;

@Component
public class TestStepPostValidator
implements Validator {
    @Inject
    private TestStepValidationHelper testStepValidationHelper;

    public boolean supports(Class<?> clazz) {
        return TestStepDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestStepDto testStepDto = (TestStepDto)target;
        if (testStepDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing test step, please do a patch request to the test step id. ");
        }
        CheckingAttributeTestStepDtoVisitor visitor = new CheckingAttributeTestStepDtoVisitor(this.testStepValidationHelper, errors);
        testStepDto.accept(visitor);
    }
}

