/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.validators.helper.TestCaseDtoValidationHelper;

@Component
public class TestCasePostValidator
implements Validator {
    @Inject
    private TestCaseDtoValidationHelper testCaseDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return TestCaseDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestCaseDto testCaseDto = (TestCaseDto)target;
        if (testCaseDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing test case, please do a patch request to the test case id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.testCaseDtoValidationHelper.checkParent(errors, testCaseDto, RestType.TEST_CASE);
        if (errors.hasErrors()) {
            return;
        }
        this.testCaseDtoValidationHelper.checkInvalidAttributeForEachTestCaseType(errors, testCaseDto);
        this.testCaseDtoValidationHelper.assignProject(testCaseDto);
        this.testCaseDtoValidationHelper.assignInfoList(errors, testCaseDto);
        this.testCaseDtoValidationHelper.checkCufs(errors, testCaseDto, BindableEntity.TEST_CASE);
    }
}

