/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.ScriptedTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDtoVisitor;
import org.squashtest.tm.plugin.rest.service.RestTestCaseService;
import org.squashtest.tm.plugin.rest.validators.helper.TestCaseDtoValidationHelper;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@Component
public class TestCasePatchValidator
implements Validator {
    private static final String NON_PATCHABLE_ATTRIBUTE = "non patchable attribute";
    @Inject
    private TestCaseDtoValidationHelper testCaseDtoValidationHelper;
    @Inject
    private RestTestCaseService restTestCaseService;
    @Inject
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;

    public boolean supports(Class<?> clazz) {
        return TestCaseDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestCaseDto patch = (TestCaseDto)target;
        this.testCaseDtoValidationHelper.checkEntityExist(errors, RestType.TEST_CASE, patch.getId());
        this.testCaseDtoValidationHelper.loadProject(patch);
        this.testCaseDtoValidationHelper.checkParent(errors, patch, RestType.TEST_CASE);
        this.testCaseDtoValidationHelper.assignInfoList(errors, patch);
        this.testCaseDtoValidationHelper.checkCufs(errors, patch, BindableEntity.TEST_CASE);
        this.testCaseDtoValidationHelper.checkInvalidAttributeForEachTestCaseType(errors, patch);
        this.checkForbiddenPatchAttributes(errors, patch);
    }

    private void checkForbiddenPatchAttributes(Errors errors, TestCaseDto patch) {
        if (patch.getSteps() != null) {
            errors.rejectValue("steps", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute steps cannot be patched. Use direct url to the steps entity instead");
        }
        if (patch.getParameters() != null) {
            errors.rejectValue("parameters", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute parameters cannot be patched. Use direct url to the parameters entity instead");
        }
        if (patch.getDatasets() != null) {
            errors.rejectValue("datasets", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute datasets cannot be patched. Use direct url to the datasets entity instead");
        }
        if (patch.getRequirementVersionCoverages() != null) {
            errors.rejectValue("requirementVersionCoverages", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute requirementVersionCoverages cannot be patched. Use /test-cases/{id}/coverages instead");
        }
        if (patch.getVerifiedRequirements() != null) {
            errors.rejectValue("verifiedRequirements", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute verifiedRequirements cannot be patched. Use /test-cases/{id}/coverages instead");
        }
        if (patch.getMilestones() != null) {
            errors.rejectValue("milestones", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute milestones cannot be patched. Use direct url to the milestones entity instead");
        }
        if (patch.getAutomatedTestReference() != null) {
            errors.rejectValue("automatedTestReference", NON_PATCHABLE_ATTRIBUTE, "The attribute automatedTestReference cannot be patched yet.");
        }
        if (patch.getAutomatedTestTechnology() != null) {
            errors.rejectValue("automatedTestTechnology", NON_PATCHABLE_ATTRIBUTE, "The attribute automatedTestTechnology cannot be patched yet.");
        }
        if (patch.getScmRepository() != null) {
            errors.rejectValue("scmRepository", NON_PATCHABLE_ATTRIBUTE, "The attribute scmRepository cannot be patched yet.");
        }
        TestCase testCase = this.restTestCaseService.getOne(patch.getId());
        this.checkTestCaseTypeWithGivenDtoType(patch, testCase);
    }

    public List<SuppressionPreviewReport> simulationDelete(List<Long> testCaseIds) {
        return this.testCaseLibraryNavigationService.simulateDeletion(testCaseIds);
    }

    private void checkTestCaseTypeWithGivenDtoType(final TestCaseDto testCasePatch, TestCase testCase) {
        TestCaseVisitor testCaseVisitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
                TestCaseDtoVisitor dtoVisitor = new TestCaseDtoVisitor(){

                    @Override
                    public void visit(TestCaseDto testCaseDto) {
                    }

                    @Override
                    public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
                        throw new IllegalArgumentException("Invalid type for Standard Test Case");
                    }

                    @Override
                    public void visit(KeywordTestCaseDto keywordTestCaseDto) {
                        throw new IllegalArgumentException("Invalid type for Standard Test Case");
                    }
                };
                testCasePatch.accept(dtoVisitor);
            }

            public void visit(KeywordTestCase keywordTestCase) {
                TestCaseDtoVisitor dtoVisitor = new TestCaseDtoVisitor(){

                    @Override
                    public void visit(TestCaseDto testCaseDto) {
                        throw new IllegalArgumentException("Invalid type for Keyword Test Case");
                    }

                    @Override
                    public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
                        throw new IllegalArgumentException("Invalid type for Keyword Test Case");
                    }

                    @Override
                    public void visit(KeywordTestCaseDto keywordTestCaseDto) {
                    }
                };
                testCasePatch.accept(dtoVisitor);
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                TestCaseDtoVisitor dtoVisitor = new TestCaseDtoVisitor(){

                    @Override
                    public void visit(TestCaseDto testCaseDto) {
                        throw new IllegalArgumentException("Invalid type for Scripted Test Case");
                    }

                    @Override
                    public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
                    }

                    @Override
                    public void visit(KeywordTestCaseDto keywordTestCaseDto) {
                        throw new IllegalArgumentException("Invalid type for Scripted Test Case");
                    }
                };
                testCasePatch.accept(dtoVisitor);
            }
        };
        testCase.accept(testCaseVisitor);
    }
}

