/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.ArrayList;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.repository.RestRequirementRepository;
import org.squashtest.tm.plugin.rest.validators.helper.RequirementVersionDtoValidationHelper;

@Component
public class RequirementVersionValidator
implements Validator {
    private static final String POST_REQUIREMENT_VERSION = "post-requirement-version";
    private static final String PATCH_REQUIREMENT_VERSION = "patch-requirement-version";
    @Inject
    private RequirementVersionDtoValidationHelper requirementVersionDtoValidationHelper;
    @Inject
    private RestRequirementRepository restRequirementRepository;

    public boolean supports(Class<?> clazz) {
        return RequirementVersionDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        RequirementVersionDto requirementVersionDto = (RequirementVersionDto)target;
        if (requirementVersionDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing requirement version, please do a patch request to the requirement version id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.requirementVersionDtoValidationHelper.checkAndAssignValues(errors, requirementVersionDto);
    }

    public void validateRequirementVersion(RequirementVersionDto requirementVersionDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementVersionDto, POST_REQUIREMENT_VERSION);
        this.validate(requirementVersionDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(requirementVersionDto, errors, POST_REQUIREMENT_VERSION);
    }

    public void validatePatchRequirementVersion(RequirementVersionDto requirementVersionDto, Long requirementId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementVersionDto, PATCH_REQUIREMENT_VERSION);
        Requirement requirement = (Requirement)this.restRequirementRepository.getOne(requirementId);
        requirementVersionDto.setProjectId(requirement.getProject().getId());
        if (requirement.getStatus().equals((Object)RequirementStatus.OBSOLETE)) {
            validation.rejectValue("status", "obsolete requirement", "Can not change an obsolete requirement");
        }
        if (requirement.getStatus().equals((Object)RequirementStatus.APPROVED) && !requirementVersionDto.isHasStatus()) {
            validation.rejectValue("status", "approved requirement", "Can not change an approved requirement");
        }
        if (requirementVersionDto.isHasName()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)validation, (String)"name", (String)"required", (String)"This attribute can't be empty");
        }
        this.requirementVersionDtoValidationHelper.checkAndAssignValuesPatch((Errors)validation, requirementVersionDto, requirement);
        if (requirementVersionDto.isHasCufs()) {
            this.requirementVersionDtoValidationHelper.checkCufs((Errors)validation, requirementVersionDto);
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(requirementVersionDto, errors, PATCH_REQUIREMENT_VERSION);
    }
}

