/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.ArrayList;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementFolderDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.validators.helper.RequirementFolderDtoValidationHelper;

@Component
public class RequirementFolderPatchValidator
implements Validator {
    private static final String PATCH_REQUIREMENT_FOLDER = "patch-requirement-folder";
    @Inject
    private RequirementFolderDtoValidationHelper requirementFolderDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return RequirementFolderDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        RequirementFolderDto folderPatch = (RequirementFolderDto)target;
        this.requirementFolderDtoValidationHelper.checkEntityExist(errors, RestType.REQUIREMENT_FOLDER, folderPatch.getId());
        this.requirementFolderDtoValidationHelper.loadProject(folderPatch);
        this.requirementFolderDtoValidationHelper.checkParent(errors, folderPatch, RestType.REQUIREMENT_FOLDER);
        this.requirementFolderDtoValidationHelper.checkCufs(errors, folderPatch, BindableEntity.REQUIREMENT_FOLDER);
    }

    public void validatePatchRequirementFolder(RequirementFolderDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, PATCH_REQUIREMENT_FOLDER);
        this.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, PATCH_REQUIREMENT_FOLDER);
    }
}

