/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectCopyParameterDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectTemplateDto;

@Component
public class GenericProjectPostValidator
implements Validator {
    @PersistenceContext
    protected EntityManager entityManager;

    public boolean supports(Class<?> clazz) {
        return GenericProjectDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, final Errors errors) {
        GenericProjectDto genericProjectDto = (GenericProjectDto)target;
        if (genericProjectDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing generic project, please do a patch request to the generic project id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        GenericProjectDtoVisitor visitor = new GenericProjectDtoVisitor(){

            @Override
            public void visit(ProjectDto projectDto) {
                if (projectDto.getTemplateId() != null) {
                    GenericProjectPostValidator.this.checkAndAssignValues(projectDto);
                    GenericProjectPostValidator.this.checkIfEntityExist(errors, projectDto.getTemplateId());
                }
            }

            @Override
            public void visit(ProjectTemplateDto projectTemplateDto) {
                if (projectTemplateDto.getProjectId() != null) {
                    GenericProjectPostValidator.this.checkAndAssignValues(projectTemplateDto);
                    GenericProjectPostValidator.this.checkIfEntityExist(errors, projectTemplateDto.getProjectId());
                }
            }
        };
        genericProjectDto.accept(visitor);
    }

    private void checkAndAssignValues(GenericProjectDto genericProjectDto) {
        if (genericProjectDto.getParams() == null) {
            genericProjectDto.setParams(new GenericProjectCopyParameterDto());
        }
    }

    private void checkIfEntityExist(Errors errors, Long id) {
        GenericProject genericProject = (GenericProject)this.entityManager.find(GenericProject.class, (Object)id);
        if (genericProject == null) {
            String message = String.format("No project of project template known for id %d", id);
            errors.rejectValue("id", "invalid id", message);
        }
    }
}

