/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.customfield.DenormalizedCustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldVisitor;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedMultiSelectField;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedNumericValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedSingleSelectField;
import org.squashtest.tm.plugin.rest.core.exception.ProgrammingError;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.core.jackson.WrappedDTO;
import org.squashtest.tm.plugin.rest.core.validation.HintedValidator;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.WrappedDtoWithDenormalizedFields;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;

@Component
public class DenormalizedFieldValueHintedValidator
implements HintedValidator {
    private static final DateFormat DATE_TESTER = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DENORMALIZED_FIELDS = "denormalizedFields";
    public static final String INVALID_VALUE = "invalid value";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    @Inject
    private DenormalizedFieldValueManager denoFinder;

    static {
        DATE_TESTER.setLenient(false);
    }

    public boolean supports(Class<?> clazz) {
        return WrappedDtoWithDenormalizedFields.class.isAssignableFrom(clazz) && WrappedDTO.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
    }

    public void validateWithHints(Object target, Errors errors, DeserializationHints hints) {
        WrappedDtoWithDenormalizedFields wrapped = (WrappedDtoWithDenormalizedFields)target;
        hints.getProject();
        Object holder = ((WrappedDTO)wrapped).getWrapped();
        if (!DenormalizedFieldHolder.class.isAssignableFrom(holder.getClass())) {
            throw new ProgrammingError("Attempted to process denormalized field values for an entity that cannot have one : '" + holder.getClass() + "'");
        }
        DenormalizedFieldHolder entity = (DenormalizedFieldHolder)holder;
        List<CustomFieldValueDto> dtos = wrapped.getDenormalizedFields();
        List currentValues = this.denoFinder.findAllForEntity(entity);
        DenormalizedValueValidationHelper helper = new DenormalizedValueValidationHelper(errors, dtos, currentValues);
        helper.validate();
    }

    private static final class DenormalizedFieldValidationVisitor
    implements DenormalizedFieldVisitor {
        private Errors errors;
        private CustomFieldValueDto dto;
        private RawValue value;

        public DenormalizedFieldValidationVisitor(Errors errors, CustomFieldValueDto dto, RawValue value) {
            this.errors = errors;
            this.dto = dto;
            this.value = value;
        }

        public void visit(DenormalizedFieldValue denoValue) {
            this.checkIsScalarValue(denoValue);
            Class<?> clazz = denoValue.getClass();
            if (DenormalizedSingleSelectField.class.isAssignableFrom(clazz)) {
                this.checkOptions((DenormalizedSingleSelectField)denoValue);
            } else if (DenormalizedNumericValue.class.isAssignableFrom(clazz)) {
                this.checkNumeric((DenormalizedNumericValue)denoValue);
            } else if (denoValue.getInputType() == InputType.DATE_PICKER) {
                this.checkDate(denoValue);
            } else if (denoValue.getInputType() == InputType.CHECKBOX) {
                this.checkBoolean(denoValue);
            }
        }

        public void visit(DenormalizedMultiSelectField multiselect) {
            this.checkIsMultiValue(multiselect);
        }

        private void checkDate(DenormalizedFieldValue denoValue) {
            if (this.value == null || this.value.getValue().isEmpty()) {
                return;
            }
            String strDate = this.value.getValue();
            try {
                DATE_TESTER.parse(strDate);
            }
            catch (ParseException parseException) {
                this.errors.rejectValue(DenormalizedFieldValueHintedValidator.DENORMALIZED_FIELDS, DenormalizedFieldValueHintedValidator.INVALID_VALUE, "The field '" + denoValue.getLabel() + "' identified by label '" + denoValue.getLabel() + "' " + "accepts dates using format 'yyyy-mm-dd' only");
            }
        }

        private void checkBoolean(DenormalizedFieldValue denoValue) {
            boolean check;
            if (this.value == null) {
                return;
            }
            String strBool = this.value.getValue().toLowerCase();
            boolean bl = check = strBool.equals(DenormalizedFieldValueHintedValidator.TRUE) || strBool.equals(DenormalizedFieldValueHintedValidator.FALSE);
            if (!check) {
                this.errors.rejectValue(DenormalizedFieldValueHintedValidator.DENORMALIZED_FIELDS, DenormalizedFieldValueHintedValidator.INVALID_VALUE, "The field '" + denoValue.getLabel() + "' identified by label '" + denoValue.getLabel() + "' " + "accepts boolean 'true' or 'false'");
            }
        }

        private void checkNumeric(DenormalizedNumericValue denoValue) {
            if (this.value == null || this.value.getValue().isEmpty()) {
                return;
            }
            String numberAsString = this.value.getValue();
            try {
                new BigDecimal(numberAsString);
            }
            catch (NumberFormatException numberFormatException) {
                String message = String.format("The field %s identified by code %s accept numeric value. The value provided is not convertible to number", denoValue.getLabel(), denoValue.getCode(), this.value.getValue());
                this.errors.rejectValue(DenormalizedFieldValueHintedValidator.DENORMALIZED_FIELDS, DenormalizedFieldValueHintedValidator.INVALID_VALUE, message);
            }
        }

        private void checkOptions(DenormalizedSingleSelectField listField) {
            List options = listField.getOptions();
            boolean valid = false;
            for (DenormalizedCustomFieldOption option : options) {
                if (!option.getLabel().equals(this.dto.getValue().getValue())) continue;
                valid = true;
            }
            if (!valid) {
                this.errors.rejectValue(DenormalizedFieldValueHintedValidator.DENORMALIZED_FIELDS, DenormalizedFieldValueHintedValidator.INVALID_VALUE, "Unknown value for list : " + listField.getCode() + " . Options are identified by label.");
            }
        }

        private void checkIsScalarValue(DenormalizedFieldValue denoValue) {
            if (this.value == null || this.value.getValues() == null || this.value.getValues().isEmpty()) {
                return;
            }
            String message = String.format("The field %s identified by code %s is a single-valued field. You provided a json array with values : %s. Please provide a standard attribute not an array.", denoValue.getLabel(), denoValue.getCode(), this.value.getValues());
            this.errors.rejectValue(DenormalizedFieldValueHintedValidator.DENORMALIZED_FIELDS, DenormalizedFieldValueHintedValidator.INVALID_VALUE, message);
        }

        private void checkIsMultiValue(DenormalizedMultiSelectField denoValue) {
            if (this.value != null && (this.value.getValues() == null || this.value.getValues().isEmpty())) {
                String message = String.format("The cuf %s identified by code %s is a multi-valued field. You provided standard attribute with value : %s. Please provide json array.", denoValue.getLabel(), denoValue.getCode(), this.value.getValue());
                this.errors.rejectValue(DenormalizedFieldValueHintedValidator.DENORMALIZED_FIELDS, DenormalizedFieldValueHintedValidator.INVALID_VALUE, message);
            }
        }
    }

    private static final class DenormalizedValueValidationHelper {
        private Errors errors;
        private List<CustomFieldValueDto> dtos;
        private List<DenormalizedFieldValue> currentValues;

        DenormalizedValueValidationHelper(Errors errors, List<CustomFieldValueDto> dtos, List<DenormalizedFieldValue> currentValues) {
            this.dtos = dtos;
            this.currentValues = currentValues;
            this.errors = errors;
        }

        void validate() {
            this.checkCodes();
            this.checkValues();
        }

        private void checkCodes() {
            for (CustomFieldValueDto dto : this.dtos) {
                DenormalizedFieldValue denoValue = this.locateByCode(dto.getCode());
                if (denoValue == null) {
                    this.errors.rejectValue(DenormalizedFieldValueHintedValidator.DENORMALIZED_FIELDS, "invalid code", "there is no field with code '" + dto.getCode() + "'");
                }
                dto.getValue();
            }
        }

        private void checkValues() {
            for (CustomFieldValueDto dto : this.dtos) {
                RawValue value = dto.getValue();
                String code = dto.getCode();
                DenormalizedFieldValue denoValue = this.locateByCode(code);
                if (denoValue == null) continue;
                DenormalizedFieldValidationVisitor visitor = new DenormalizedFieldValidationVisitor(this.errors, dto, value);
                denoValue.accept((DenormalizedFieldVisitor)visitor);
            }
        }

        private DenormalizedFieldValue locateByCode(String code) {
            for (DenormalizedFieldValue value : this.currentValues) {
                if (!value.getCode().equals(code)) continue;
                return value;
            }
            return null;
        }
    }
}

