/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.validators.helper.CampaignDtoValidationHelper;

@Component
public class CampaignPostValidator
implements Validator {
    private static final String NON_POSTABLE_ATTRIBUTE = "non postable attribute";
    @Inject
    private CampaignDtoValidationHelper campaignDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return CampaignDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        CampaignDto campaignDto = (CampaignDto)target;
        if (campaignDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing campaign, please do a patch request to the campaign id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.campaignDtoValidationHelper.checkParent(errors, campaignDto, RestType.CAMPAIGN);
        if (errors.hasErrors()) {
            return;
        }
        this.campaignDtoValidationHelper.assignProject(campaignDto);
        this.campaignDtoValidationHelper.checkAndAssignStatus(errors, campaignDto);
        this.campaignDtoValidationHelper.checkCufs(errors, campaignDto, BindableEntity.CAMPAIGN);
        this.checkForbiddenPostAttributes(errors, campaignDto);
    }

    private void checkForbiddenPostAttributes(Errors errors, CampaignDto post) {
        if (post.getIterations() != null) {
            errors.rejectValue("iterations", NON_POSTABLE_ATTRIBUTE, "Only attributes belonging to the campaign itself can be posted. The attribute iterations cannot be posted. Use direct url to the iterations entity instead");
        }
        if (post.getMilestones() != null) {
            errors.rejectValue("milestones", NON_POSTABLE_ATTRIBUTE, "Only attributes belonging to the campaign itself can be posted. The attribute milestones cannot be posted. Use direct url to the milestones entity instead");
        }
        if (post.getTestPlans() != null) {
            errors.rejectValue("test-plan", NON_POSTABLE_ATTRIBUTE, "Only attributes belonging to the campaign itself can be posted. The attribute test plan cannot be posted. Use direct url to the test plan entity instead");
        }
    }
}

